/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.yunhsm.pool;

import com.xdja.hsm.api.SdfApi;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDKUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsmConnection {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SdfApi sdfApi;
    private long[] dev;
    private volatile long[] ses = new long[]{0L};
    private int id;
    private long startTime;

    public HsmConnection(SdfApi sdfApi, long[] dev) throws SdfSDKException {
        this.sdfApi = sdfApi;
        this.dev = dev;
        YunhsmSdfSDKUtils.openSession(sdfApi, dev, this.ses);
    }

    public SdfApi getSdfApi() {
        return this.sdfApi;
    }

    public long[] getDev() {
        return this.dev;
    }

    public long[] getSes() {
        return this.ses;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public synchronized void reopen() throws SdfSDKException {
        YunhsmSdfSDKUtils.closeSession(this.sdfApi, this.dev, this.ses);
        this.ses = new long[]{0L};
        YunhsmSdfSDKUtils.openSession(this.sdfApi, this.dev, this.ses);
    }

    public synchronized void close() throws SdfSDKException {
        YunhsmSdfSDKUtils.closeSession(this.sdfApi, this.dev, this.ses);
        this.ses = new long[]{0L};
    }

    public String getDeviceInfo() throws SdfSDKException {
        return YunhsmSdfSDKUtils.getDeviceInfo(this.sdfApi, this.dev, this.ses);
    }

    public boolean isConnection() {
        try {
            YunhsmSdfSDKUtils.getDeviceInfo(this.sdfApi, this.dev, this.ses);
            return true;
        }
        catch (SdfSDKException e) {
            this.logger.debug("getDeviceInfo dev = {} session = {}, error={}", new Object[]{this.dev[0], this.ses[0], e});
            return false;
        }
    }
}

