/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.test;

import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLCertUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLExtensionUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GMSSLKeyStore {
    private KeyStore serverKeyStore;
    private char[] password;
    private KeyStore trustKeyStore;
    private PrivateKey rootKey;
    private X509Certificate rootCert;
    private PrivateKey signKey;
    private X509Certificate signCert;
    private PrivateKey encKey;
    private X509Certificate encCert;

    public GMSSLKeyStore(String password, PrivateKey rootKey, X509Certificate rootCert, PrivateKey signKey, X509Certificate signCert, PrivateKey encKey, X509Certificate encCert) throws NoSuchAlgorithmException, CertificateException, NoSuchProviderException, KeyStoreException, IOException {
        this.password = password.toCharArray();
        this.rootKey = rootKey;
        this.rootCert = rootCert;
        this.signKey = signKey;
        this.signCert = signCert;
        this.encKey = encKey;
        this.encCert = encCert;
        this.serverKeyStore = GMSSLKeyStoreUtils.generateGMSSLKeyStore((String)password, (X509Certificate)rootCert, (String)"sign", (PrivateKey)signKey, (X509Certificate)signCert, (String)"enc", (PrivateKey)encKey, (X509Certificate)encCert);
        this.trustKeyStore = GMSSLKeyStoreUtils.generateGMSSLTrustStore((X509Certificate)rootCert);
    }

    public KeyStore getServerKeyStore() {
        return this.serverKeyStore;
    }

    public char[] getPassword() {
        return this.password;
    }

    public KeyStore getTrustKeyStore() {
        return this.trustKeyStore;
    }

    public PrivateKey getRootKey() {
        return this.rootKey;
    }

    public X509Certificate getRootCert() {
        return this.rootCert;
    }

    public PrivateKey getSignKey() {
        return this.signKey;
    }

    public X509Certificate getSignCert() {
        return this.signCert;
    }

    public PrivateKey getEncKey() {
        return this.encKey;
    }

    public X509Certificate getEncCert() {
        return this.encCert;
    }

    public void save() throws Exception {
        File pathf = new File("." + File.separator + "target" + File.separator + "tomcat" + File.separator + "cert");
        if (!pathf.exists()) {
            pathf.mkdirs();
        }
        String path = pathf.getAbsolutePath() + File.separator;
        FileOutputStream trustOut = new FileOutputStream(path + "trust.keystore");
        this.getTrustKeyStore().store(trustOut, this.getPassword());
        trustOut.close();
        FileOutputStream serverOut = new FileOutputStream(path + "server.keystore");
        this.getServerKeyStore().store(serverOut, this.getPassword());
        serverOut.close();
    }

    public static GMSSLKeyStore generateGMSSLKeyStoreByBC() throws Exception {
        AtomicLong serialNumber = new AtomicLong(System.currentTimeMillis());
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(5, -1);
        Date noBefore = calendar.getTime();
        calendar.add(1, 1);
        Date noAfter = calendar.getTime();
        String rootDN = "CN=ROOTCA,O=XDJA,C=CN";
        ArrayList<Extension> rootExtensions = new ArrayList<Extension>();
        rootExtensions.add(GMSSLExtensionUtils.genRootCertKeyUsageExtension());
        KeyPair rootKeyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        X509Certificate rootCert = GMSSLCertUtils.generateCertByBC((String)rootDN, (String)rootDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootKeyPair.getPrivate(), (PublicKey)rootKeyPair.getPublic(), rootExtensions);
        String signDN = "CN=SIGN,OU=SERVER,O=XDJA,C=CN";
        ArrayList<Extension> signExtensions = new ArrayList<Extension>();
        signExtensions.add(GMSSLExtensionUtils.genSignatureCertKeyUsageExtension());
        KeyPair signKeyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        X509Certificate signCert = GMSSLCertUtils.generateCertByBC((String)rootDN, (String)signDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootKeyPair.getPrivate(), (PublicKey)signKeyPair.getPublic(), signExtensions);
        String encDN = "CN=ENC,OU=SERVER,O=XDJA,C=CN";
        ArrayList<Extension> encExtensions = new ArrayList<Extension>();
        encExtensions.add(GMSSLExtensionUtils.genEncryptCertKeyUsageExtension());
        KeyPair encKeyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        X509Certificate encCert = GMSSLCertUtils.generateCertByBC((String)rootDN, (String)encDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootKeyPair.getPrivate(), (PublicKey)encKeyPair.getPublic(), encExtensions);
        return new GMSSLKeyStore("password", rootKeyPair.getPrivate(), rootCert, signKeyPair.getPrivate(), signCert, encKeyPair.getPrivate(), encCert);
    }

    public static GMSSLKeyStore generateGMSSLKeyStoreByYunhsm(int privateKeyIndex, String privateKeyPassword) throws Exception {
        AtomicLong serialNumber = new AtomicLong(System.currentTimeMillis());
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(5, -1);
        Date noBefore = calendar.getTime();
        calendar.add(1, 1);
        Date noAfter = calendar.getTime();
        String rootDN = "CN=ROOTCA,O=XDJA,C=CN";
        ArrayList<Extension> rootExtensions = new ArrayList<Extension>();
        rootExtensions.add(GMSSLExtensionUtils.genRootCertKeyUsageExtension());
        PublicKey rootPublicKey = GMSSLSM2KeyUtils.getSignPublicKeyByYunhsm((int)privateKeyIndex);
        SdfPrivateKey rootPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey((int)privateKeyIndex, (String)privateKeyPassword);
        X509Certificate rootCert = GMSSLCertUtils.generateCertByYunhsm((String)rootDN, (String)rootDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootPrivateKey, (PublicKey)rootPublicKey, rootExtensions);
        String signDN = "CN=SIGN,O=SERVER,O=XDJA,C=CN";
        ArrayList<Extension> signExtensions = new ArrayList<Extension>();
        signExtensions.add(GMSSLExtensionUtils.genSignatureCertKeyUsageExtension());
        PublicKey signPublicKey = GMSSLSM2KeyUtils.getSignPublicKeyByYunhsm((int)privateKeyIndex);
        SdfPrivateKey signPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey((int)privateKeyIndex, (String)privateKeyPassword);
        X509Certificate signCert = GMSSLCertUtils.generateCertByYunhsm((String)rootDN, (String)signDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootPrivateKey, (PublicKey)signPublicKey, signExtensions);
        String encDN = "CN=ENC,O=SERVER,O=XDJA,C=CN";
        ArrayList<Extension> encExtensions = new ArrayList<Extension>();
        encExtensions.add(GMSSLExtensionUtils.genEncryptCertKeyUsageExtension());
        PublicKey encPublicKey = GMSSLSM2KeyUtils.getEncryptPublicKeyByYunhsm((int)privateKeyIndex);
        SdfPrivateKey encPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey((int)privateKeyIndex, (String)privateKeyPassword);
        X509Certificate encCert = GMSSLCertUtils.generateCertByYunhsm((String)rootDN, (String)encDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootPrivateKey, (PublicKey)encPublicKey, encExtensions);
        return new GMSSLKeyStore("password", (PrivateKey)rootPrivateKey, rootCert, (PrivateKey)signPrivateKey, signCert, (PrivateKey)encPrivateKey, encCert);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

