package com.xdja.pki.gmssl.test;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLCertUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLExtensionUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;

import java.io.File;
import java.io.FileWriter;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.*;
import java.util.concurrent.atomic.AtomicLong;


public class GMSSLX509CertUtils {
    public static AtomicLong serialNumber;


    public static Date noBefore;

    public static Date noAfter;

    public static void first() {
        serialNumber = new AtomicLong(System.currentTimeMillis());
        //生成 CA密钥、CA根证书
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(Calendar.DATE, -1);
        noBefore = calendar.getTime();
        calendar.add(Calendar.YEAR, 30);
        noAfter = calendar.getTime();
    }

    public static X509Certificate genRootCertByYunHsm(String rootDN, int rootPrivateKeyIndex, String rootPrivateKeyPassword) throws Exception {

        first();
        List<Extension> rootExtensions = new ArrayList<>();
        rootExtensions.add(GMSSLExtensionUtils.genRootCertKeyUsageExtension());
        rootExtensions.add(GMSSLExtensionUtils.genBasicConstraintsExtension(1));
        PublicKey rootPublicKey = GMSSLSM2KeyUtils.getSignPublicKeyByYunhsm(rootPrivateKeyIndex);
        PrivateKey rootPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey(rootPrivateKeyIndex, rootPrivateKeyPassword);
        X509Certificate rootCert = GMSSLCertUtils.generateCertByYunhsm(
                rootDN, rootDN,
                BigInteger.valueOf(serialNumber.getAndIncrement()),
                noBefore, noAfter,
                rootPrivateKey,
                rootPublicKey,
                GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(),
                rootExtensions
        );

        return rootCert;

    }

    public static X509Certificate genEncCertByYunHsm(String encDN, int encPrivateKeyIndex, String rootDN, int rootPrivateKeyIndex, String rootPrivateKeyPassword) throws Exception {
        first();
        List<Extension> encExtensions = new ArrayList<>();
        encExtensions.add(GMSSLExtensionUtils.genEncryptCertKeyUsageExtension());
        PublicKey encPublicKey = GMSSLSM2KeyUtils.getEncryptPublicKeyByYunhsm(encPrivateKeyIndex);

        X509Certificate encCert = GMSSLCertUtils.generateCertByYunhsm(
                rootDN, encDN,
                BigInteger.valueOf(serialNumber.getAndIncrement()),
                noBefore, noAfter,
                rootPrivateKeyIndex, rootPrivateKeyPassword,
                encPublicKey,
                GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(),
                encExtensions
        );
        return encCert;
    }


    public static X509Certificate genSignCertByYunHsm(String signDN, int signPrivateKeyIndex, String rootDN, int rootPrivateKeyIndex, String rootPrivateKeyPassword) throws Exception {
        first();
        List<Extension> signExtensions = new ArrayList<>();
        signExtensions.add(GMSSLExtensionUtils.genSignatureCertKeyUsageExtension());

        PublicKey signPublicKey = GMSSLSM2KeyUtils.getSignPublicKeyByYunhsm(signPrivateKeyIndex);


        X509Certificate signCert = GMSSLCertUtils.generateCertByYunhsm(
                rootDN, signDN,
                BigInteger.valueOf(serialNumber.getAndIncrement()),
                noBefore, noAfter,
                rootPrivateKeyIndex, rootPrivateKeyPassword,
                signPublicKey,
                GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(),
                signExtensions
        );
        return signCert;
    }

    public static X509Certificate genRootCertByBC(String rootDN, KeyPair rootKeyPair) throws Exception {

        first();


        List<Extension> rootExtensions = new ArrayList<>();
        rootExtensions.add(GMSSLExtensionUtils.genRootCertKeyUsageExtension());
        rootExtensions.add(GMSSLExtensionUtils.genBasicConstraintsExtension(1));

        X509Certificate rootCert = GMSSLCertUtils.generateCertByBC(
                rootDN, rootDN,
                BigInteger.valueOf(serialNumber.getAndIncrement()),
                noBefore, noAfter,
                rootKeyPair.getPrivate(),
                rootKeyPair.getPublic(),
                GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(),
                rootExtensions
        );
        return rootCert;
    }

    public static X509Certificate genSignCertByBC(String signDN, KeyPair signKeyPair, String rootDN, KeyPair caKeyPair) throws Exception {
        return genSignCertByBC(signDN, signKeyPair, rootDN, caKeyPair, null);
    }
    public static X509Certificate genSignCertByBC(String signDN, KeyPair signKeyPair, String rootDN, KeyPair caKeyPair, String ip) throws Exception {
        first();
        //生成 server 密钥、证书
        List<Extension> signExtensions = new ArrayList<>();
        signExtensions.add(GMSSLExtensionUtils.genSignatureCertKeyUsageExtension());
        if (ip != null){
            Map<Integer, String> map = new HashMap<>();
            map.put(GeneralName.iPAddress, ip);
            Extension subjectAlternativeName = GMSSLExtensionUtils.genSubjectAlternativeName(false, map);
            signExtensions.add(subjectAlternativeName);
        }

        X509Certificate signCert = GMSSLCertUtils.generateCertByBC(
                rootDN, signDN,
                BigInteger.valueOf(serialNumber.getAndIncrement()),
                noBefore, noAfter,
                caKeyPair.getPrivate(),
                signKeyPair.getPublic(),
                GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(),
                signExtensions
        );
        return signCert;
    }

    public static X509Certificate genEncCertByBC(String encDN, KeyPair encKeyPair, String rootDN, KeyPair caKeyPair) throws Exception {
        first();
        List<Extension> encExtensions = new ArrayList<>();

        encExtensions.add(GMSSLExtensionUtils.genEncryptCertKeyUsageExtension());
        X509Certificate encCert = GMSSLCertUtils.generateCertByBC(
                rootDN, encDN,
                BigInteger.valueOf(serialNumber.getAndIncrement()),
                noBefore, noAfter,
                caKeyPair.getPrivate(),
                encKeyPair.getPublic(),
                GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(),
                encExtensions
        );

        return encCert;
    }


    public static X509Certificate genRootCertByPCIE(String rootDN, int rootPrivateKeyIndex, String rootPrivateKeyPassword) throws Exception {

        first();
        List<Extension> rootExtensions = new ArrayList<>();
        rootExtensions.add(GMSSLExtensionUtils.genRootCertKeyUsageExtension());
        rootExtensions.add(GMSSLExtensionUtils.genBasicConstraintsExtension(1));
        PublicKey rootPublicKey = GMSSLSM2KeyUtils.getSignPublicKeyByPcie(rootPrivateKeyIndex);
        X509Certificate rootCert = GMSSLCertUtils.generateCertByPcie(
                rootDN, rootDN,
                BigInteger.valueOf(serialNumber.getAndIncrement()),
                noBefore, noAfter,
                rootPrivateKeyIndex, rootPrivateKeyPassword,
                rootPublicKey,
                GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(),
                rootExtensions
        );

        return rootCert;

    }

    public static X509Certificate genEncCertByPCIE(String encDN, int encPrivateKeyIndex, String rootDN, int rootPrivateKeyIndex, String rootPrivateKeyPassword) throws Exception {
        first();
        List<Extension> encExtensions = new ArrayList<>();
        encExtensions.add(GMSSLExtensionUtils.genEncryptCertKeyUsageExtension());
        PublicKey encPublicKey = GMSSLSM2KeyUtils.getEncryptPublicKeyByPcie(encPrivateKeyIndex);

        X509Certificate encCert = GMSSLCertUtils.generateCertByPcie(
                rootDN, encDN,
                BigInteger.valueOf(serialNumber.getAndIncrement()),
                noBefore, noAfter,
                rootPrivateKeyIndex, rootPrivateKeyPassword,
                encPublicKey,
                GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(),
                encExtensions
        );
        return encCert;
    }


    public static X509Certificate genSignCertByPCIE(String signDN, int signPrivateKeyIndex, String rootDN, int rootPrivateKeyIndex, String rootPrivateKeyPassword) throws Exception {
        first();
        List<Extension> signExtensions = new ArrayList<>();
        signExtensions.add(GMSSLExtensionUtils.genSignatureCertKeyUsageExtension());

        PublicKey signPublicKey = GMSSLSM2KeyUtils.getSignPublicKeyByPcie(signPrivateKeyIndex);


        X509Certificate signCert = GMSSLCertUtils.generateCertByPcie(
                rootDN, signDN,
                BigInteger.valueOf(serialNumber.getAndIncrement()),
                noBefore, noAfter,
                rootPrivateKeyIndex, rootPrivateKeyPassword,
                signPublicKey,
                GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(),
                signExtensions
        );
        return signCert;
    }

    public static void saveCert(X509Certificate caCert, X509Certificate caServerSignCert, X509Certificate caServerEncCert, PrivateKey caServerSignPriKey, PrivateKey caServerEncPriKey, String path) throws Exception {
        path = path + File.separator;
        File pathf = new File(path);
        if (!pathf.exists()) {
            pathf.mkdirs();
        }
        String password = "password";
        String signAlias = "sign";
        String encAlias = "enc";

        KeyStore serverKeyStore = GMSSLKeyStoreUtils.generateGMSSLKeyStore(password, caCert,
                signAlias, caServerSignPriKey, caServerSignCert,
                encAlias, caServerEncPriKey, caServerEncCert);
        KeyStore trustKeyStore = GMSSLKeyStoreUtils.generateGMSSLTrustStore(caCert);
        GMSSLX509Utils.writeCertificateToPem(path, "ca", caCert);
        GMSSLX509Utils.writeObjectToPem(path, "ca_public", caCert.getPublicKey());
        GMSSLX509Utils.writeCertificateToCer(path, "ca", caCert);

        GMSSLX509Utils.writeCertificateToPem(path, "sign", caServerSignCert);
        GMSSLX509Utils.writeObjectToPem(path, "sign_public", caServerSignCert.getPublicKey());
        if (caServerSignPriKey instanceof SdfPrivateKey) {
            FileWriter fileWritter = new FileWriter(path + "ca_server_key.pem", false);
            fileWritter.write(caServerSignPriKey.toString());

            fileWritter.close();
        } else {
            GMSSLX509Utils.writeObjectToPem(path, "sign_private", caServerSignPriKey);
            GMSSLX509Utils.writeObjectToPem(path, "enc_private", caServerEncPriKey);
            GMSSLX509Utils.writeKeyStoreToP12(serverKeyStore, "password".toCharArray(), path, "sign");
            GMSSLX509Utils.writeKeyStoreToP12(serverKeyStore, "password".toCharArray(), path, "enc");
        }
        GMSSLX509Utils.writeCertificateToCer(path, "sign", caServerSignCert);
        GMSSLX509Utils.writeCertificateToPem(path, "enc", caServerEncCert);
        GMSSLX509Utils.writeCertificateToCer(path, "enc", caServerEncCert);
        GMSSLKeyStoreUtils.saveGMSSLKeyStore(serverKeyStore, "password", path, "server");
        GMSSLKeyStoreUtils.saveGMSSLKeyStore(trustKeyStore, "password", path, "trust");
        GMSSLX509Utils.writeKeyStoreToP12(trustKeyStore, "password".toCharArray(), path, "trust");

    }

}
