/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.test;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLCertUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLExtensionUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import java.io.File;
import java.io.FileWriter;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.asn1.x509.Extension;

public class GMSSLX509CertUtils {
    public static AtomicLong serialNumber;
    public static Date noBefore;
    public static Date noAfter;

    public static void first() {
        serialNumber = new AtomicLong(System.currentTimeMillis());
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(5, -1);
        noBefore = calendar.getTime();
        calendar.add(1, 30);
        noAfter = calendar.getTime();
    }

    public static X509Certificate genRootCertByYunHsm(String rootDN, int rootPrivateKeyIndex, String rootPrivateKeyPassword) throws Exception {
        GMSSLX509CertUtils.first();
        ArrayList<Extension> rootExtensions = new ArrayList<Extension>();
        rootExtensions.add(GMSSLExtensionUtils.genRootCertKeyUsageExtension());
        rootExtensions.add(GMSSLExtensionUtils.genBasicConstraintsExtension((Integer)1));
        PublicKey rootPublicKey = GMSSLSM2KeyUtils.getSignPublicKeyByYunhsm((int)rootPrivateKeyIndex);
        SdfPrivateKey rootPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey((int)rootPrivateKeyIndex, (String)rootPrivateKeyPassword);
        X509Certificate rootCert = GMSSLCertUtils.generateCertByYunhsm((String)rootDN, (String)rootDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootPrivateKey, (PublicKey)rootPublicKey, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), rootExtensions);
        return rootCert;
    }

    public static X509Certificate genEncCertByYunHsm(String encDN, int encPrivateKeyIndex, String rootDN, int rootPrivateKeyIndex, String rootPrivateKeyPassword) throws Exception {
        GMSSLX509CertUtils.first();
        ArrayList<Extension> encExtensions = new ArrayList<Extension>();
        encExtensions.add(GMSSLExtensionUtils.genEncryptCertKeyUsageExtension());
        PublicKey encPublicKey = GMSSLSM2KeyUtils.getEncryptPublicKeyByYunhsm((int)encPrivateKeyIndex);
        X509Certificate encCert = GMSSLCertUtils.generateCertByYunhsm((String)rootDN, (String)encDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (int)rootPrivateKeyIndex, (String)rootPrivateKeyPassword, (PublicKey)encPublicKey, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), encExtensions);
        return encCert;
    }

    public static X509Certificate genSignCertByYunHsm(String signDN, int signPrivateKeyIndex, String rootDN, int rootPrivateKeyIndex, String rootPrivateKeyPassword) throws Exception {
        GMSSLX509CertUtils.first();
        ArrayList<Extension> signExtensions = new ArrayList<Extension>();
        signExtensions.add(GMSSLExtensionUtils.genSignatureCertKeyUsageExtension());
        PublicKey signPublicKey = GMSSLSM2KeyUtils.getSignPublicKeyByYunhsm((int)signPrivateKeyIndex);
        X509Certificate signCert = GMSSLCertUtils.generateCertByYunhsm((String)rootDN, (String)signDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (int)rootPrivateKeyIndex, (String)rootPrivateKeyPassword, (PublicKey)signPublicKey, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), signExtensions);
        return signCert;
    }

    public static X509Certificate genRootCertByBC(String rootDN, KeyPair rootKeyPair) throws Exception {
        GMSSLX509CertUtils.first();
        ArrayList<Extension> rootExtensions = new ArrayList<Extension>();
        rootExtensions.add(GMSSLExtensionUtils.genRootCertKeyUsageExtension());
        rootExtensions.add(GMSSLExtensionUtils.genBasicConstraintsExtension((Integer)1));
        X509Certificate rootCert = GMSSLCertUtils.generateCertByBC((String)rootDN, (String)rootDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootKeyPair.getPrivate(), (PublicKey)rootKeyPair.getPublic(), (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), rootExtensions);
        return rootCert;
    }

    public static X509Certificate genSignCertByBC(String signDN, KeyPair signKeyPair, String rootDN, KeyPair caKeyPair) throws Exception {
        return GMSSLX509CertUtils.genSignCertByBC(signDN, signKeyPair, rootDN, caKeyPair, null);
    }

    public static X509Certificate genSignCertByBC(String signDN, KeyPair signKeyPair, String rootDN, KeyPair caKeyPair, String ip) throws Exception {
        GMSSLX509CertUtils.first();
        ArrayList<Extension> signExtensions = new ArrayList<Extension>();
        signExtensions.add(GMSSLExtensionUtils.genSignatureCertKeyUsageExtension());
        if (ip != null) {
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            map.put(7, ip);
            Extension subjectAlternativeName = GMSSLExtensionUtils.genSubjectAlternativeName((boolean)false, map);
            signExtensions.add(subjectAlternativeName);
        }
        X509Certificate signCert = GMSSLCertUtils.generateCertByBC((String)rootDN, (String)signDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)caKeyPair.getPrivate(), (PublicKey)signKeyPair.getPublic(), (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), signExtensions);
        return signCert;
    }

    public static X509Certificate genEncCertByBC(String encDN, KeyPair encKeyPair, String rootDN, KeyPair caKeyPair) throws Exception {
        GMSSLX509CertUtils.first();
        ArrayList<Extension> encExtensions = new ArrayList<Extension>();
        encExtensions.add(GMSSLExtensionUtils.genEncryptCertKeyUsageExtension());
        X509Certificate encCert = GMSSLCertUtils.generateCertByBC((String)rootDN, (String)encDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)caKeyPair.getPrivate(), (PublicKey)encKeyPair.getPublic(), (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), encExtensions);
        return encCert;
    }

    public static X509Certificate genRootCertByPCIE(String rootDN, int rootPrivateKeyIndex, String rootPrivateKeyPassword) throws Exception {
        GMSSLX509CertUtils.first();
        ArrayList<Extension> rootExtensions = new ArrayList<Extension>();
        rootExtensions.add(GMSSLExtensionUtils.genRootCertKeyUsageExtension());
        rootExtensions.add(GMSSLExtensionUtils.genBasicConstraintsExtension((Integer)1));
        PublicKey rootPublicKey = GMSSLSM2KeyUtils.getSignPublicKeyByPcie((int)rootPrivateKeyIndex);
        X509Certificate rootCert = GMSSLCertUtils.generateCertByPcie((String)rootDN, (String)rootDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (int)rootPrivateKeyIndex, (String)rootPrivateKeyPassword, (PublicKey)rootPublicKey, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), rootExtensions);
        return rootCert;
    }

    public static X509Certificate genEncCertByPCIE(String encDN, int encPrivateKeyIndex, String rootDN, int rootPrivateKeyIndex, String rootPrivateKeyPassword) throws Exception {
        GMSSLX509CertUtils.first();
        ArrayList<Extension> encExtensions = new ArrayList<Extension>();
        encExtensions.add(GMSSLExtensionUtils.genEncryptCertKeyUsageExtension());
        PublicKey encPublicKey = GMSSLSM2KeyUtils.getEncryptPublicKeyByPcie((int)encPrivateKeyIndex);
        X509Certificate encCert = GMSSLCertUtils.generateCertByPcie((String)rootDN, (String)encDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (int)rootPrivateKeyIndex, (String)rootPrivateKeyPassword, (PublicKey)encPublicKey, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), encExtensions);
        return encCert;
    }

    public static X509Certificate genSignCertByPCIE(String signDN, int signPrivateKeyIndex, String rootDN, int rootPrivateKeyIndex, String rootPrivateKeyPassword) throws Exception {
        GMSSLX509CertUtils.first();
        ArrayList<Extension> signExtensions = new ArrayList<Extension>();
        signExtensions.add(GMSSLExtensionUtils.genSignatureCertKeyUsageExtension());
        PublicKey signPublicKey = GMSSLSM2KeyUtils.getSignPublicKeyByPcie((int)signPrivateKeyIndex);
        X509Certificate signCert = GMSSLCertUtils.generateCertByPcie((String)rootDN, (String)signDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (int)rootPrivateKeyIndex, (String)rootPrivateKeyPassword, (PublicKey)signPublicKey, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), signExtensions);
        return signCert;
    }

    public static void saveCert(X509Certificate caCert, X509Certificate caServerSignCert, X509Certificate caServerEncCert, PrivateKey caServerSignPriKey, PrivateKey caServerEncPriKey, String path) throws Exception {
        File pathf = new File(path = path + File.separator);
        if (!pathf.exists()) {
            pathf.mkdirs();
        }
        String password = "password";
        String signAlias = "sign";
        String encAlias = "enc";
        KeyStore serverKeyStore = GMSSLKeyStoreUtils.generateGMSSLKeyStore((String)password, (X509Certificate)caCert, (String)signAlias, (PrivateKey)caServerSignPriKey, (X509Certificate)caServerSignCert, (String)encAlias, (PrivateKey)caServerEncPriKey, (X509Certificate)caServerEncCert);
        KeyStore trustKeyStore = GMSSLKeyStoreUtils.generateGMSSLTrustStore((X509Certificate)caCert);
        GMSSLX509Utils.writeCertificateToPem((String)path, (String)"ca", (X509Certificate)caCert);
        GMSSLX509Utils.writeObjectToPem((String)path, (String)"ca_public", (Object)caCert.getPublicKey());
        GMSSLX509Utils.writeCertificateToCer((String)path, (String)"ca", (X509Certificate)caCert);
        GMSSLX509Utils.writeCertificateToPem((String)path, (String)"sign", (X509Certificate)caServerSignCert);
        GMSSLX509Utils.writeObjectToPem((String)path, (String)"sign_public", (Object)caServerSignCert.getPublicKey());
        if (caServerSignPriKey instanceof SdfPrivateKey) {
            FileWriter fileWritter = new FileWriter(path + "ca_server_key.pem", false);
            fileWritter.write(caServerSignPriKey.toString());
            fileWritter.close();
        } else {
            GMSSLX509Utils.writeObjectToPem((String)path, (String)"sign_private", (Object)caServerSignPriKey);
            GMSSLX509Utils.writeObjectToPem((String)path, (String)"enc_private", (Object)caServerEncPriKey);
            GMSSLX509Utils.writeKeyStoreToP12((KeyStore)serverKeyStore, (char[])"password".toCharArray(), (String)path, (String)"sign");
            GMSSLX509Utils.writeKeyStoreToP12((KeyStore)serverKeyStore, (char[])"password".toCharArray(), (String)path, (String)"enc");
        }
        GMSSLX509Utils.writeCertificateToCer((String)path, (String)"sign", (X509Certificate)caServerSignCert);
        GMSSLX509Utils.writeCertificateToPem((String)path, (String)"enc", (X509Certificate)caServerEncCert);
        GMSSLX509Utils.writeCertificateToCer((String)path, (String)"enc", (X509Certificate)caServerEncCert);
        GMSSLKeyStoreUtils.saveGMSSLKeyStore((KeyStore)serverKeyStore, (String)"password", (String)path, (String)"server");
        GMSSLKeyStoreUtils.saveGMSSLKeyStore((KeyStore)trustKeyStore, (String)"password", (String)path, (String)"trust");
        GMSSLX509Utils.writeKeyStoreToP12((KeyStore)trustKeyStore, (char[])"password".toCharArray(), (String)path, (String)"trust");
    }
}

