/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package com.xdja.pki.gmssl.tomcat.plugin;

import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.yunhsm.HsmConnectionPool;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDK;
import org.apache.tomcat.util.net.*;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.XDJAJsseProvider;

import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import java.net.Socket;
import java.security.Security;

;

/* JSSEImplementation:

   Concrete implementation class for JSSE

   @author EKR
*/

public class XDJAJSSEImplementation extends SSLImplementation {

    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        if (Security.getProvider(XDJAJsseProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new XDJAJsseProvider());
        }
        HsmConnectionPool.getInstance();
    }

    @Override
    public String getImplementationName(){
        return "XDJAJSSE";
    }

    @Override
    public ServerSocketFactory getServerSocketFactory(AbstractEndpoint<?> endpoint)  {
        return new XDJAJSSESocketFactory(endpoint);
    }

    @Override
    public SSLSupport getSSLSupport(Socket s) {
        return new XDJAJSSESupport((SSLSocket) s);
    }

    @Override
    public SSLSupport getSSLSupport(SSLSession session) {
        return new XDJAJSSESupport(session);
    }

    @Override
    public SSLUtil getSSLUtil(AbstractEndpoint<?> endpoint) {
        return new XDJAJSSESocketFactory(endpoint);
    }
}
