/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.tomcat.plugin;

import com.xdja.pki.gmssl.GMSSLContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.res.StringManager;

public class XDJAJSSESocketFactory
implements ServerSocketFactory,
SSLUtil {
    private static final Log log = LogFactory.getLog(XDJAJSSESocketFactory.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.tomcat.util.net.jsse.res");
    private static final String defaultProtocol = "TLS";
    private static final String defaultKeystoreType = "JKS";
    private static final String defaultKeystoreFile = System.getProperty("user.home") + "/.keystore";
    private static final int defaultSessionCacheSize = 0;
    private static final int defaultSessionTimeout = 86400;
    private static final String ALLOW_ALL_SUPPORTED_CIPHERS = "ALL";
    public static final String DEFAULT_KEY_PASS = "changeit";
    private AbstractEndpoint<?> endpoint;
    protected SSLServerSocketFactory sslProxy = null;
    protected boolean allowUnsafeLegacyRenegotiation = false;
    protected boolean requireClientAuth = false;
    protected boolean wantClientAuth = false;

    public XDJAJSSESocketFactory(AbstractEndpoint<?> endpoint) {
        this.endpoint = endpoint;
    }

    public ServerSocket createSocket(int port) throws IOException {
        this.init();
        ServerSocket socket = this.sslProxy.createServerSocket(port);
        this.initServerSocket(socket);
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog) throws IOException {
        this.init();
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog);
        this.initServerSocket(socket);
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        this.init();
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog, ifAddress);
        this.initServerSocket(socket);
        return socket;
    }

    public Socket acceptSocket(ServerSocket socket) throws IOException {
        SSLSocket asock = null;
        try {
            asock = (SSLSocket)socket.accept();
        }
        catch (SSLException e) {
            throw new SocketException("SSL handshake error" + e.toString());
        }
        return asock;
    }

    public void handshake(Socket sock) throws IOException {
        SSLSession session = ((SSLSocket)sock).getSession();
        if (session.getCipherSuite().equals("SSL_NULL_WITH_NULL_NULL")) {
            throw new IOException("SSL handshake failed. Ciper suite in SSL Session is SSL_NULL_WITH_NULL_NULL");
        }
    }

    public String[] getEnableableCiphers(SSLContext context) {
        return context.getSupportedSSLParameters().getCipherSuites();
    }

    protected String getKeystorePassword() {
        String keystorePass = this.endpoint.getKeystorePass();
        if (keystorePass == null) {
            keystorePass = this.endpoint.getKeyPass();
        }
        if (keystorePass == null) {
            keystorePass = DEFAULT_KEY_PASS;
        }
        return keystorePass;
    }

    protected KeyStore getKeystore(String type, String provider, String pass) throws IOException {
        String keystoreFile = this.endpoint.getKeystoreFile();
        if (keystoreFile == null) {
            keystoreFile = defaultKeystoreFile;
        }
        return GMSSLContext.getKeystore((String)keystoreFile, (String)type, (String)provider, (String)pass);
    }

    protected KeyStore getTrustStore() throws IOException {
        String truststoreProvider;
        String truststoreType;
        String truststorePassword;
        String truststoreFile = this.endpoint.getTruststoreFile();
        if (truststoreFile == null) {
            truststoreFile = System.getProperty("javax.net.ssl.trustStore");
        }
        if ((truststorePassword = this.endpoint.getTruststorePass()) == null) {
            truststorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
        }
        if ((truststoreType = this.endpoint.getTruststoreType()) == null) {
            truststoreType = System.getProperty("javax.net.ssl.trustStoreType");
        }
        if ((truststoreProvider = this.endpoint.getTruststoreProvider()) == null) {
            truststoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider");
        }
        return GMSSLContext.getTrustStore((String)truststoreFile, (String)truststoreType, (String)truststoreProvider, (String)truststorePassword);
    }

    void init() throws IOException {
        try {
            String clientAuthStr = this.endpoint.getClientAuth();
            if ("true".equalsIgnoreCase(clientAuthStr) || "yes".equalsIgnoreCase(clientAuthStr)) {
                this.requireClientAuth = true;
            } else if ("want".equalsIgnoreCase(clientAuthStr)) {
                this.wantClientAuth = true;
            }
            SSLContext context = this.createSSLContext();
            context.init(this.getKeyManagers(), this.getTrustManagers(), null);
            SSLSessionContext sessionContext = context.getServerSessionContext();
            if (sessionContext != null) {
                this.configureSessionContext(sessionContext);
            }
            this.sslProxy = context.getServerSocketFactory();
            this.allowUnsafeLegacyRenegotiation = "true".equals(this.endpoint.getAllowUnsafeLegacyRenegotiation());
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage(), e);
        }
    }

    public SSLContext createSSLContext() throws Exception {
        String protocol = this.endpoint.getSslProtocol();
        if (protocol == null) {
            protocol = defaultProtocol;
        }
        return SSLContext.getInstance(protocol, "XDJAJSSE");
    }

    public KeyManager[] getKeyManagers() throws Exception {
        String password = this.getKeystorePassword();
        KeyStore ks = this.getKeystore(this.endpoint.getKeystoreType(), this.endpoint.getKeystoreProvider(), password);
        KeyManagerFactory keyMgrFact = KeyManagerFactory.getInstance("PKIX", "XDJAJSSE");
        keyMgrFact.init(ks, password.toCharArray());
        return keyMgrFact.getKeyManagers();
    }

    public TrustManager[] getTrustManagers() throws Exception {
        KeyStore ts = this.getTrustStore();
        TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", "XDJAJSSE");
        trustMgrFact.init(ts);
        return trustMgrFact.getTrustManagers();
    }

    public void configureSessionContext(SSLSessionContext sslSessionContext) {
        int sessionCacheSize = this.endpoint.getSessionCacheSize() != null ? Integer.parseInt(this.endpoint.getSessionCacheSize()) : 0;
        int sessionTimeout = this.endpoint.getSessionTimeout() != null ? Integer.parseInt(this.endpoint.getSessionTimeout()) : 86400;
        sslSessionContext.setSessionCacheSize(sessionCacheSize);
        sslSessionContext.setSessionTimeout(sessionTimeout);
    }

    public String[] getEnableableProtocols(SSLContext context) {
        return new String[]{"GMSSLv1.1"};
    }

    protected void configureClientAuth(SSLServerSocket socket) {
        if (this.wantClientAuth) {
            socket.setWantClientAuth(this.wantClientAuth);
        } else {
            socket.setNeedClientAuth(this.requireClientAuth);
        }
    }

    private void initServerSocket(ServerSocket ssocket) {
        SSLServerSocket socket = (SSLServerSocket)ssocket;
        this.configureClientAuth(socket);
    }
}

