/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.SafeKey.utils.pool;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.utils.pool.MiniPcieConnection;
import java.util.Vector;

public class MiniPcieConnectionPool {
    public JNIAPI jniapi = new JNIAPI();
    public int[] devEnum = new int[1];
    public int sm2Index = 0;
    public int maxhandle = 10;
    public int nowDev = 1;
    long[] handle = new long[1];
    public Vector<MiniPcieConnection> sm2unlock = new Vector();
    public Vector<MiniPcieConnection> sm2lock = new Vector();
    public Vector<MiniPcieConnection> calculateunlock = new Vector();
    public Vector<MiniPcieConnection> calculatelock = new Vector();

    private MiniPcieConnectionPool() {
        this.init();
    }

    private void init() {
        int i;
        this.jniapi.EnumDev(272, this.devEnum);
        for (i = 0; i < this.maxhandle; ++i) {
            this.jniapi.OpenDev(this.sm2Index, this.handle);
            MiniPcieConnection miniPcieConnection = new MiniPcieConnection(true, this.handle[0], this.sm2Index);
            this.sm2unlock.add(miniPcieConnection);
        }
        for (i = 0; i < this.devEnum[0]; ++i) {
            if (i == this.sm2Index) continue;
            for (int k = 0; k < this.maxhandle; ++k) {
                this.jniapi.OpenDev(i, this.handle);
                MiniPcieConnection miniPcieConnection = new MiniPcieConnection(false, this.handle[0], i);
                this.calculateunlock.add(miniPcieConnection);
            }
        }
    }

    public synchronized MiniPcieConnection getSm2Handle() {
        MiniPcieConnection t = this.getMiniPcieConnection(this.sm2unlock, this.sm2lock);
        if (t != null) {
            return t;
        }
        t = this.sm2Create();
        this.sm2lock.add(t);
        return t;
    }

    private synchronized MiniPcieConnection sm2Create() {
        this.jniapi.EnumDev(272, this.devEnum);
        long[] handle = new long[1];
        this.jniapi.OpenDev(this.sm2Index, handle);
        return new MiniPcieConnection(true, handle[0], 0);
    }

    public synchronized MiniPcieConnection getCalculateHandle() {
        MiniPcieConnection t1 = this.getMiniPcieConnection(this.calculateunlock, this.calculatelock);
        if (t1 != null) {
            return t1;
        }
        if (this.nowDev >= this.devEnum[0]) {
            this.nowDev = 0;
        }
        if (this.nowDev == this.sm2Index) {
            ++this.nowDev;
        }
        MiniPcieConnection t = this.calculateCreate(this.nowDev);
        ++this.nowDev;
        this.calculateunlock.add(t);
        return t;
    }

    private MiniPcieConnection getMiniPcieConnection(Vector<MiniPcieConnection> unlock, Vector<MiniPcieConnection> lock) {
        if (unlock.size() > 0) {
            for (MiniPcieConnection t : unlock) {
                if (t.isValid(this.jniapi)) {
                    unlock.remove(t);
                    lock.add(t);
                    return t;
                }
                unlock.remove(t);
                this.closeHandle(t);
            }
        }
        return null;
    }

    private synchronized MiniPcieConnection calculateCreate(int index) {
        this.jniapi.EnumDev(272, this.devEnum);
        this.jniapi.OpenDev(index, this.handle);
        return new MiniPcieConnection(true, this.handle[0], index);
    }

    public void closeHandle(MiniPcieConnection connection) {
        try {
            this.jniapi.CloseDev(connection.getHandle());
            if (connection.isSM2Handle()) {
                this.sm2lock.remove(connection);
            } else {
                this.calculatelock.remove(connection);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            connection = null;
        }
    }

    public synchronized void release(MiniPcieConnection connection) {
        try {
            if (connection.isSM2Handle()) {
                this.sm2lock.remove(connection);
                this.sm2unlock.add(connection);
            } else {
                this.calculatelock.remove(connection);
                this.calculateunlock.add(connection);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            connection = null;
        }
    }

    public static MiniPcieConnectionPool getInstance() {
        return MiniPcieConnectionPoolLoader.INSTANCE;
    }

    private static class MiniPcieConnectionPoolLoader {
        private static final MiniPcieConnectionPool INSTANCE = new MiniPcieConnectionPool();

        private MiniPcieConnectionPoolLoader() {
        }
    }
}

