/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.SafeKey.utils;

import com.xdja.SafeKey.utils.MiniPcieXKFUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import org.bouncycastle.util.encoders.Hex;

public class MiniPcieSymmetricEncryptUtils {
    public static byte[] sm1EcbWithPkcs5Padding(byte[] key, byte[] data, boolean isEncrypt) throws Exception {
        return MiniPcieSymmetricEncryptUtils.sm1EcbWithPkcs7Padding(key, data, isEncrypt);
    }

    public static byte[] sm1EcbWithPkcs7Padding(byte[] key, byte[] data, boolean isEncrypt) throws Exception {
        if (isEncrypt) {
            byte[] paddingData = GMSSLX509Utils.paddingData((byte[])data, (boolean)true);
            return MiniPcieXKFUtils.sm1(key, paddingData, 1, null);
        }
        byte[] plainText = MiniPcieXKFUtils.sm1(key, data, 0, null);
        return GMSSLX509Utils.removePadding((byte[])data, (byte[])plainText, (boolean)true);
    }

    public static byte[] sm1EcbWithSslv3Padding(byte[] key, byte[] data, boolean isEncrypt) throws Exception {
        if (isEncrypt) {
            byte[] paddingData = GMSSLX509Utils.paddingData((byte[])data, (boolean)false);
            return MiniPcieXKFUtils.sm1(key, paddingData, 1, null);
        }
        byte[] plainText = MiniPcieXKFUtils.sm1(key, data, 0, null);
        return GMSSLX509Utils.removePadding((byte[])data, (byte[])plainText, (boolean)false);
    }

    public static byte[] sm4EcbWithPkcs5Padding(byte[] key, byte[] data, boolean isEncrypt) throws Exception {
        return MiniPcieSymmetricEncryptUtils.sm4EcbWithPkcs7Padding(key, data, isEncrypt);
    }

    public static byte[] sm4EcbWithPkcs7Padding(byte[] key, byte[] data, boolean isEncrypt) throws Exception {
        if (isEncrypt) {
            byte[] paddingData = GMSSLX509Utils.paddingData((byte[])data, (boolean)true);
            return MiniPcieXKFUtils.sm4(key, paddingData, 1, null);
        }
        byte[] plainText = MiniPcieXKFUtils.sm4(key, data, 0, null);
        return GMSSLX509Utils.removePadding((byte[])data, (byte[])plainText, (boolean)true);
    }

    public static byte[] sm4EcbWithSslv3Padding(byte[] key, byte[] data, boolean isEncrypt) throws Exception {
        if (isEncrypt) {
            byte[] paddingData = GMSSLX509Utils.paddingData((byte[])data, (boolean)false);
            return MiniPcieXKFUtils.sm4(key, paddingData, 1, null);
        }
        byte[] plainText = MiniPcieXKFUtils.sm4(key, data, 0, null);
        return GMSSLX509Utils.removePadding((byte[])data, (byte[])plainText, (boolean)false);
    }

    public static byte[] sm1CbcWithPkcs5Padding(byte[] key, byte[] data, byte[] iv, boolean isEncrypt) throws Exception {
        return MiniPcieSymmetricEncryptUtils.sm1CbcWithPkcs7Padding(key, data, iv, isEncrypt);
    }

    public static byte[] sm1CbcWithPkcs7Padding(byte[] key, byte[] data, byte[] iv, boolean isEncrypt) throws Exception {
        if (isEncrypt) {
            byte[] paddingData = GMSSLX509Utils.paddingData((byte[])data, (boolean)true);
            System.out.println(Hex.toHexString((byte[])paddingData));
            return MiniPcieXKFUtils.sm1(key, paddingData, 17, iv);
        }
        byte[] plainText = MiniPcieXKFUtils.sm1(key, data, 16, iv);
        return GMSSLX509Utils.removePadding((byte[])data, (byte[])plainText, (boolean)true);
    }

    public static byte[] sm1CbcWithSslv3Padding(byte[] key, byte[] data, byte[] iv, boolean isEncrypt) throws Exception {
        if (isEncrypt) {
            byte[] paddingData = GMSSLX509Utils.paddingData((byte[])data, (boolean)false);
            return MiniPcieXKFUtils.sm1(key, paddingData, 17, iv);
        }
        byte[] plainText = MiniPcieXKFUtils.sm1(key, data, 16, iv);
        return GMSSLX509Utils.removePadding((byte[])data, (byte[])plainText, (boolean)false);
    }

    public static byte[] sm4CbcWithPkcs5Padding(byte[] key, byte[] data, byte[] iv, boolean isEncrypt) throws Exception {
        return MiniPcieSymmetricEncryptUtils.sm4CbcWithPkcs7Padding(key, data, iv, isEncrypt);
    }

    public static byte[] sm4CbcWithPkcs7Padding(byte[] key, byte[] data, byte[] iv, boolean isEncrypt) throws Exception {
        if (isEncrypt) {
            byte[] paddingData = GMSSLX509Utils.paddingData((byte[])data, (boolean)true);
            return MiniPcieXKFUtils.sm4(key, paddingData, 17, iv);
        }
        byte[] plainText = MiniPcieXKFUtils.sm4(key, data, 16, iv);
        return GMSSLX509Utils.removePadding((byte[])data, (byte[])plainText, (boolean)true);
    }

    public static byte[] sm4CbcWithSslv3Padding(byte[] key, byte[] data, byte[] iv, boolean isEncrypt) throws Exception {
        if (isEncrypt) {
            byte[] paddingData = GMSSLX509Utils.paddingData((byte[])data, (boolean)false);
            return MiniPcieXKFUtils.sm4(key, paddingData, 17, iv);
        }
        byte[] plainText = MiniPcieXKFUtils.sm4(key, data, 16, iv);
        return GMSSLX509Utils.removePadding((byte[])data, (byte[])plainText, (boolean)false);
    }
}

