/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.SafeKey.utils;

import com.xdja.SafeKey.Sm2PublicKey;
import com.xdja.SafeKey.bean.MiniPcieIndexEnum;
import com.xdja.SafeKey.utils.MiniPcieXKFUtils;
import com.xdja.pki.gmssl.asn1.crypto.ASN1SM2Cipher;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import java.security.PublicKey;
import org.bouncycastle.util.encoders.Hex;

public class MiniPcieSm2EncryptUtils {
    public static byte[] encrypt(byte[] data, PublicKey publicKey, boolean isAsn1) throws Exception {
        if (isAsn1) {
            byte[] cipher = MiniPcieXKFUtils.sm2Encrypt(data, new Sm2PublicKey(publicKey));
            return MiniPcieSm2EncryptUtils.getASN1Cipher(cipher).getEncoded();
        }
        return MiniPcieXKFUtils.sm2Encrypt(data, new Sm2PublicKey(publicKey));
    }

    public static byte[] decrypt(byte[] cipher, int index, String password, boolean isAsn1) throws Exception {
        if (isAsn1) {
            byte[] originalCipher = MiniPcieSm2EncryptUtils.getOriginalCipher(cipher);
            return MiniPcieXKFUtils.sm2Decrypt(originalCipher, MiniPcieIndexEnum.getInfoFromIndex(index).getEncPrivateIndex(), password);
        }
        return MiniPcieXKFUtils.sm2Decrypt(cipher, MiniPcieIndexEnum.getInfoFromIndex(index).getEncPrivateIndex(), password);
    }

    private static ASN1SM2Cipher getASN1Cipher(byte[] cipher) {
        byte[] PO = new byte[65];
        PO[0] = 4;
        byte[] x = new byte[32];
        byte[] y = new byte[32];
        byte[] m = new byte[32];
        byte[] c = new byte[cipher.length - 1 - x.length - y.length - m.length];
        System.arraycopy(cipher, 1, x, 0, x.length);
        System.arraycopy(cipher, 1 + x.length, y, 0, y.length);
        System.arraycopy(cipher, 1 + x.length + y.length, c, 0, c.length);
        System.arraycopy(cipher, 1 + x.length + y.length + c.length, m, 0, m.length);
        return new ASN1SM2Cipher(x, y, m, c);
    }

    private static byte[] getOriginalCipher(byte[] cipher) {
        ASN1SM2Cipher sm2Cipher = ASN1SM2Cipher.getInstance((Object)cipher);
        assert (sm2Cipher != null);
        byte[] x = GMSSLByteArrayUtils.changeByteArrayLength((byte[])sm2Cipher.getxCoordinate().toByteArray(), (int)32);
        byte[] y = GMSSLByteArrayUtils.changeByteArrayLength((byte[])sm2Cipher.getyCoordinate().toByteArray(), (int)32);
        byte[] m = sm2Cipher.getHash();
        byte[] c = sm2Cipher.getCipherText();
        byte[] original = new byte[1 + x.length + y.length + m.length + c.length];
        byte[] PO = new byte[]{4};
        System.arraycopy(PO, 0, original, 0, 1);
        System.arraycopy(x, 0, original, 1, x.length);
        System.arraycopy(y, 0, original, 1 + x.length, y.length);
        System.arraycopy(c, 0, original, 1 + x.length + y.length, c.length);
        System.arraycopy(m, 0, original, 1 + x.length + y.length + c.length, m.length);
        System.out.println(" x " + Hex.toHexString((byte[])x));
        System.out.println(" y " + Hex.toHexString((byte[])y));
        System.out.println(" m " + Hex.toHexString((byte[])m));
        System.out.println(" c " + Hex.toHexString((byte[])c));
        System.out.println(" original " + Hex.toHexString((byte[])original));
        return original;
    }
}

