//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.xdja.SafeKey;

import com.xdja.pki.gmssl.jni.NativeUtils;

import java.io.IOException;

public class JNIAPI {
    public static final int CT_ALL = 0;
    public static final int CT_USBKEY = 256;
    public static final int CT_USBDEV = 272;
    public static final int CT_TF = 512;
    public static final int CT_TF_XDJA = 528;
    public static final int CT_TF_INCOMM = 544;
    public static final int CT_TF_ZTEIC_OLD = 545;
    public static final int CT_TF_ZTEIC_NEW = 546;
    public static final int CT_TF_INCOMM_V1 = 547;
    public static final int CT_TF_INCOMM_V2 = 548;
    public static final int CT_TF_INCOMM_EX = 549;
    public static final int CT_TF_RDFOX = 560;
    public static final int CT_TF_REDFOX_LOW = 561;
    public static final int CT_TF_REDFOX_HIGH = 562;
    public static final int CT_TIC = 768;
    public static final int CT_NET = 1024;
    public static final int CT_IOS = 1280;
    public static final int ROOT_DIR = 1;
    public static final int APP_DIR = 2;
    public static final int FILE_BINARY = 1;
    public static final int FILE_PUBLIC = 2;
    public static final int FILE_PRIVATE = 3;
    public static final int KEY_SM1_ENCRYPT = 1;
    public static final int KEY_SM1_DECRYPT = 2;
    public static final int KEY_PIN_UNLOCK = 3;
    public static final int KEY_PIN_ROLE = 4;
    public static final int KEY_SM1_RELOAD = 5;
    public static final int KEY_DES_RELOAD = 6;
    public static final int OP_DECRYPT = 0;
    public static final int OP_ENCRYPT = 1;
    public static final int ECB_MODE = 0;
    public static final int CBC_MODE = 16;
    public static final int ECB_DECRYPT = 0;
    public static final int ECB_ENCRYPT = 1;
    public static final int CBC_DECRYPT = 16;
    public static final int CBC_ENCRYPT = 17;
    public static final int CARD_RSA_LEN = 128;
    public static final int CARD_PRIME_LEN = 64;
    public static final int MAX_RSA_MODULUS_BITS = 2048;
    public static final int MAX_CARD_RSA_LEN = 256;
    public static final int MIN_CARD_PRIME_LEN = 128;
    public static final int KEY_LEN_SM2 = 32;
    public static final int SM2_KEY_GENERATE_DICT_SEND = 0;
    public static final int SM2_KEY_GENERATE_DICT_RECV = 1;
    public static final int SM2_UID_MAX = 64;
    public static final int SM2_BLOCK_MAX = 158;
    public static final int ROLE_NUM = 5;
    public static final int ROLE_A = 1;
    public static final int ROLE_B = 2;
    public static final int ROLE_C = 3;
    public static final int ROLE_D = 4;
    public static final int ROLE_E = 5;
    public static final int SIGN_HASH = 0;
    public static final int SIGN_NOHASH = 1;
    public static final int USB_NORMAL_ZONE = 0;
    public static final int USB_SECU_ZONE = 1;
    public static final int USB_HEDD_ZONE = 2;
    public static final int USB_INNOSTOR_ZONE = 3;
    public static final int USB_READ_TEMP = 0;
    public static final int USB_WRITE_TEMP = 1;
    public static final int USB_READ_FOREVER = 2;
    public static final int USB_WRITE_FORERVER = 3;
    public static final int INNOSTOR_WRITE_TEMP = 4;
    public static final int PIN_MAX_LEN = 16;
    public static final int PIN_MIN_LEN = 3;
    public static final int FILE_ID_LEN = 2;
    public static final int KEY_LEN_MAX = 32;
    public static final int DIR_NAME_LEN = 8;
    public static final int XKR_OK = 0;

    static {
        try {
            String os = System.getProperty("os.name");
            if ("Linux".equals(os)) {
                NativeUtils.loadLibraryFromJar("/libSafeKey.so");
            }
            if (os.startsWith("Windows")) {
                NativeUtils.loadLibraryFromJar("/SafeKey.dll");
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JNIAPI() {
    }

    /**
     * @return 错误码
     * @brief 获取卡库版本
     * @param[out] version   卡库版本
     * @param[out] verLen 长度
     * @retval XKR_OK 成功
     */
    public native int GetVersion(byte[] version, int[] verLen);

    /**
     * @return 错误码
     * @brief 通过设备索引打开设备，返回设备句柄
     * 说明：需要先枚举设备
     * @param[in] index   设备索引,从0开始,上限是枚举到的设备数
     * @param[out] hHandle 设备句柄
     * @retval XKR_OK 成功
     */
    public native int EnumDev(int devType, int[] devNum);

    /**
     * @return 错误码
     * @brief 通过设备索引打开设备，返回设备句柄
     * 说明：需要先枚举设备
     * @param[in] index   设备索引,从0开始,上限是枚举到的设备数
     * @param[out] hHandle 设备句柄
     * @retval XKR_OK 成功
     */
    public native int OpenDev(int index, long[] hHandle);

    /**
     * @return 错误码
     * @brief 打开指定设备, 返回设备句柄
     * 说明：无需枚举设备
     * @param[in] devName TF卡挂载路径,约定以'/'结束,如 /mnt/sdcard/, j:/
     * USB设备名称,如 /dev/sdd  //./PHYSICALDRIVE4
     * SPI设备节点,如 /dev/spidev1.0
     * @param[out] hHandle 设备句柄
     * @retval XKR_OK 成功
     */
    public native int OpenDevByName(byte[] devName, long[] hHandle);

    /**
     * @return 错误码
     * @brief 关闭设备
     * @param[in] hHandle 设备句柄
     * @retval XKR_OK 成功
     */
    public native int CloseDev(long hHandle);

    /**
     * @return 错误码
     * @brief 获得设备独占使用权（开启事务锁）
     * 超时时间20秒
     * 应用程序在函数组合或事务操作前通过该接口获取设备独占使用权，结束后必须立即释放独占权
     * @param[in] hHandle 设备句柄
     * @retval XKR_OK 成功
     */
    public native int LockDev(long hHandle);

    /**
     * @return 错误码
     * @brief 释放设备独占使用权（结束事务锁）
     * @param[in] hHandle 设备句柄
     * @retval XKR_OK 成功
     */
    public native int UnlockDev(long hHandle);

    /**
     * @return 错误码
     * @brief 设备命令传输
     * @param[in] hHandle 设备句柄
     * @param[in] pCmd    设备命令（APDU指令）
     * @param[in] cmdLen  命令长度
     * @param[out] outBuf  返回结果数据
     * @param[out] outlen  输入表示结果数据缓冲大小，输出表示结果数据实际长度
     * @retval XKR_OK 成功
     */
    public native int Transmit(long hHandle, byte[] pCmd, int cmdLen, byte[] outBuf, int[] outlen);

    /**
     * @return 错误码
     * @brief 获取设备信息，包括卡ID、COS版本、卡类型等
     * @param[in] hHandle 设备句柄
     * @param[out] pDevInfo 返回设备信息
     * @retval XKR_OK 成功
     */
    public native int GetDevInfo(long var1, DeviceInfo var2);

    /**
     * @return 错误码
     * @brief 设置卡驱动日志保存路径
     * @param[in] logPath 日志保存路径
     * @retval XKR_OK 成功
     */
    public native int SetLogPath(byte[] logPath);

    /**
     * @return 错误码
     * @brief 修改PIN
     * 说明：修改PIN成功后，已具有当前PIN权限，不需要重新校验PIN
     * @param[in] hHandle 设备句柄
     * @param[in] pinRole PIN码角色
     * @param[in] oldpin  旧PIN码
     * @param[in] oldlen  旧PIN码长度
     * @param[in] newpin  新PIN码
     * @param[in] newlen  新PIN码长度
     * @retval XKR_OK          成功
     * @retval XKR_PWD_N       正数,剩余重试次数
     * @retval XKR_PASSWORD    密码错误,剩余重试次数0
     * @retval XKR_KEY_LOCKED  密钥被锁死
     */
    public native int ChangePIN(long hHandle, int pinRole, byte[] oldpin, int oldlen, byte[] newpin, int newlen);

    /**
     * @return 重试次数或错误码
     * @brief 获取PIN码剩余重试次数
     * @param[in] hHandle 设备句柄
     * @param[in] pinRole PIN码角色
     * @retval XKR_PWD_N       正数,剩余重试次数
     * @retval XKR_PASSWORD    剩余重试次数0（已锁死）
     */
    public native int GetPinTryCount(long hHandle, int pinRole);

    /**
     * @return 错误码
     * @brief 校验PIN
     * 用于口令验证以获得某种安全状态
     * @param[in] hHandle 设备句柄
     * @param[in] pinRole PIN码角色
     * @param[in] pin     PIN码
     * @param[in] pinlen  PIN码长度
     * @retval XKR_OK          成功
     * @retval XKR_PWD_N       正数,剩余重试次数
     * @retval XKR_PASSWORD    密码错误,剩余重试次数0
     * @retval XKR_KEY_LOCKED  密钥被锁死
     */
    public native int VerifyPIN(long hHandle, int pinRole, byte[] pin, int pinlen);

    /**
     * @return 错误码
     * @brief 解锁PIN
     * 说明：解锁密钥只能解锁特定角色PIN码，在初始化时指定。
     * @param[in] hHandle 设备句柄
     * @param[in] id      解锁密钥ID
     * @param[in] key     解锁码
     * @param[in] keylen  解锁码长度
     * @param[in] newpin  新PIN码
     * @param[in] newlen  新PIN码长度
     * @retval XKR_OK 成功
     */
    public native int UnlockPIN(long hHandle, int id, byte[] key, int keylen, byte[] newpin, int newlen);

    /**
     * @return 错误码
     * @brief 卡重置，清除安全状态
     * @param[in] hHandle 设备句柄
     * @retval XKR_OK 成功
     */
    public native int CardReset(long hHandle);

    /**
     * @return 错误码
     * @brief 外部认证，认证通过后获取密钥对应的权限
     * 过程：卡内取随机数，经外部SM1加密，再将密文送入卡内做外部认证（解密并比较）
     * 要求：外部SM1加密密钥和卡内外部认证密钥相同
     * @param[in] hHandle     设备句柄
     * @param[in] exterAuthID 外部认证密钥ID
     * @param[in] encRandom   16字节的随机数密文，经外部SM1加密
     * @retval XKR_OK 成功
     */
    public native int ExternAuth(long hHandle, byte exterAuthID, byte[] encRandom);

    /**
     * @return 错误码
     * @brief 内部认证（等同于SM1加密）
     * 过程： 卡外产生随机数, 并送入卡内做内部认证运算, 将密文返回; 再由卡外解密并比较
     * @param[in] hHandle  设备句柄
     * @param[in] pDataIn  外部传入数据
     * @param[in] dataLen  外部传入数据长度(16的整数倍)
     * @param[in] flag     指示加解密模式,ECB_DECRYPT、ECB_ENCRYPT、CBC_DECRYPT、CBC_ENCRYPT。
     * @param[in] kID      密钥标识ID(仅限0、SM1加密密钥、SM1解密密钥和内部认证密钥四种情况)
     * 当KID为0时, 表示临时密钥做内部认证运算；当kID不为零时, 表示所使用的密钥识号（密钥仅限SM1加密密钥、SM1解密密钥和内部认证密钥）
     * @param[in] tmpKey   临时密钥   当kID=0时,tmpKey有效
     * @param[out] pDataOut SM1运算结果
     * @param[in,out] pIV  输入iv输出iv 在CBC时有效
     * @retval XKR_OK 成功
     */
    public native int InterAuth(long hHandle, Byte[] pDataIn, int dataLen, int flag, byte kID, byte[] tmpKey, byte[] pDataOut, byte[] pIV);

    /**
     * @return 错误码
     * @brief 创建目录
     * 条件:创建应用目录时，具有当前目录下，创建目录的权限
     * 创建根目录时，当前卡文件系统必须为空。
     * @param[in] hHandle 设备句柄
     * @param[in] pDir    目录属性结构，见XDJA_DIR
     * @retval XKR_OK 成功
     */
    public native int CreateDir(long hHandle, Directory pDir);

    /**
     * @return 错误码
     * @brief 通过ID选择文件或目录
     * 按文件标识符选择，选择当前目录下基本文件或子目录文件。
     * 在任何情况下均可通过标识符3F00选择MF
     * @param[in] hHandle 设备句柄
     * @param[in] fid     文件或目录id
     * @retval XKR_OK 成功
     */
    public native int SelectFile(long hHandle, byte[] fid);

    /**
     * @return 错误码
     * @brief 删除文件
     * 说明：需要权限
     * @param[in] hHandle 设备句柄
     * @param[in] fid     文件ID，全0表示删除目录下所有文件
     * @retval XKR_OK 成功
     */
    public native int DeleteFile(long hHandle, byte[] fid);

    /**
     * @return 错误码
     * @brief 获取当前目录剩余容量
     * @param[in] hHandle 设备句柄
     * @param[out] size    剩余容量,单位字节Byte
     * @retval XKR_OK 成功
     */
    public native int GetDirSize(long hHandle, int[] size);

    /**
     * @return 错误码
     * @brief 创建文件
     * 条件:具有当前目录下，创建文件的权限
     * @param[in] hHandle 设备句柄
     * @param[in] pFile   文件属性结构
     * @retval XKR_OK 成功
     */
    public native int CreateFile(long hHandle, MiniPcieFile pFile);

    /**
     * @return 错误码
     * @brief 取文件属性
     * @param[in] hHandle 设备句柄
     * @param[in] fid     文件ID
     * @param[out] pFile  文件属性，仅文件类型和文件大小有效
     * @retval XKR_OK 成功
     */
    public native int GetFileInfo(long hHandle, byte[] fid, MiniPcieFile pFile);

    /**
     * @return 错误码
     * @brief 读文件
     * 条件：具有读该文件的权限
     * @param[in] hHandle 设备句柄
     * @param[in] fid     文件ID
     * @param[in] readPos 起始位置
     * @param[in] readLen 要读取的长度
     * @param[out] pDataout 读取内容缓冲区
     * @retval XKR_OK 成功
     */
    public native int ReadFile(long hHandle, byte[] fid, int readPos, int readLen, byte[] pDataout);

    /**
     * @return 错误码
     * @brief 写文件
     * 条件：具有写该文件的权限
     * @param[in] hHandle 设备句柄
     * @param[in] fid     文件ID
     * @param[in] writePos 起始位置
     * @param[in] writeLen 写入内容的长度
     * @param[out] pDatain 写入内容
     * @retval XKR_OK 成功
     */
    public native int WriteFile(long hHandle, byte[] fid, int writePos, int writeLen, byte[] pDatain);

    /**
     * @return 错误码
     * @brief 读RSA公钥
     * 条件：具有读RSA公钥的权限
     * @param[in] hHandle 设备句柄
     * @param[in] fid     文件ID
     * @param[out] pPub    RSA公钥
     * @retval XKR_OK 成功
     */
    public native int ReadRsaPubKey(long hHandle, byte[] fid, RsaPublicKey pPub);

    /**
     * @return 错误码
     * @brief 写RSA公钥
     * 条件：具有写RSA公钥的权限
     * @param[in] hHandle 设备句柄
     * @param[in] fid     文件ID
     * @param[in] pPub    RSA公钥
     * @retval XKR_OK 成功
     */
    public native int WriteRsaPubKey(long hHandle, byte[] fid, RsaPublicKey pPub);

    /**
     * @return 错误码
     * @brief 读sm2公钥
     * 条件：具有读sm2公钥的权限
     * @param[in] hHandle 设备句柄
     * @param[in] fid     文件ID
     * @param[out] pPub    sm2公钥
     * @retval XKR_OK 成功
     */
    public native int ReadSm2PubKey(long hHandle, byte[] fid, Sm2PublicKey pPub);

    /**
     * @return 错误码
     * @brief 写sm2公钥
     * 条件：具有写sm2公钥的权限
     * @param[in] hHandle 设备句柄
     * @param[in] fid     文件ID
     * @param[in] pPub    sm2公钥
     * @retval XKR_OK 成功
     */
    public native int WriteSm2PubKey(long hHandle, byte[] fid, Sm2PublicKey pPub);

    public native int WriteSm2PriKey(long hHandle, byte[] fid, Sm2PrivateKey pPri);

    /**
     * @return 错误码
     * @brief 读证书
     * 条件：具有读证书的权限
     * @param[in] hHandle   设备句柄
     * @param[in] fid       证书文件ID
     * @param[out] certBuf  证书信息
     * @param[out] certLen  证书信息长度
     * @retval XKR_OK 成功
     */
    public native int ReadCert(long hHandle, byte[] fid, byte[] certBuf, int[] certLen);

    /**
     * @return 错误码
     * @brief 写证书
     * 条件：具有写证书的权限
     * @param[in] hHandle   设备句柄
     * @param[in] fid       证书文件ID
     * @param[in] certBuf   证书信息(DER编码)
     * @param[in] certLen   证书信息长度
     * @retval XKR_OK              成功
     * @retval XKR_NO_POWER        权限不够
     * @retval XKR_FILE_NOT_EXIST  文件不存在
     */
    public native int WriteCert(long hHandle, byte[] fid, byte[] certBuf, int certLen);

    /**
     * @return 错误码
     * @brief 卡内产生随机数
     * @param[in] hHandle 设备句柄
     * @param[in] len     需要获取的随机数长度
     * @param[out] Random 输出的随机数缓冲区
     * @retval XKR_OK 成功
     */
    public native int GenRandom(long hHandle, int len, byte[] pRandom);

    /**
     * @return 错误码
     * @brief 创建对称密钥
     * 条件:具有当前目录下，增加密钥的权限
     * @param[in] hHandle 设备句柄
     * @param[in] pAttr   对称密钥属性结构
     * @retval XKR_OK 成功
     */
    public native int CreateKey(long hHandle, KeyAttr pKey);

    /**
     * @return 错误码
     * @brief 更新密钥
     * 条件：具有更新该密钥的权限
     * @param[in] hHandle 设备句柄
     * @param[in] type    导入方式(4bit) 和 导入密钥类型(4bit)。本版本支持明文导入。
     * @param[in] pDataIn 密钥数据。密钥长度由密钥类型自动决定。在本版本中，SM1密钥为16字节
     * @param[in] kID     密钥ID
     * @retval XKR_OK 成功
     */
    public native int ImportKey(long hHandle, int type, byte[] pDatain, byte kID);

    /**
     * @return 错误码
     * @brief SM1加解密运算（硬算法），使用卡内密钥
     * @param[in] hHandle  设备句柄
     * @param[in] pDataIn  被运算的数据
     * @param[in] dataLen  输入数据长度
     * @param[in] flag     指示加密、解密与运算模式。
     * @param[out] pDataOut SM1运算结果
     * @param[in] kID      密钥ID
     * @param[in,out] pIV  输入iv输出iv 在CBC时有效
     * @retval XKR_OK 成功
     */
    public native int SM1(long hHandle, byte[] pDataIn, int dataLen, int flag, byte[] pDataOut, byte kID, byte[] pIV);

    /**
     * @return 错误码
     * @brief 导入临时SM1密钥
     * @param[in] hHandle 设备句柄
     * @param[in] tmpkey  SM1密钥 16字节
     * @retval XKR_OK 成功
     */
    public native int ImportTmpKey(long hHandle, byte[] tmpkey);

    /**
     * @return 错误码
     * @brief SM1加解密（硬算法），使用临时SM1密钥
     * @param[in] hHandle  设备句柄
     * @param[in] pDataIn  被运算的数据。
     * @param[in] dataLen  输入数据长度。
     * @param[in] flag     指示加密、解密与运算模式。
     * @param[out] pDataOut SM1运算结果。
     * @param[in] pIV      输入iv输出iv 在CBC时有效
     * @retval XKR_OK 成功
     */
    public native int TmpSM1(long hHandle, byte[] pDataIn, int dataLen, int flag, byte[] pDataOut, byte[] pIV);

    /**
     * @return 错误码
     * @brief SM1加解密（硬算法），卡外送入密钥
     * @param[in] hHandle  设备句柄
     * @param[in] tmpkey   SM1密钥 16字节
     * @param[in] pDataIn  输入数据，数据长度为16整数倍
     * @param[in] dataLen  输入数据长度。
     * @param[in] flag     指示加密、解密与运算模式。
     * @param[out] pDataOut SM1运算结果。
     * @param[in] pIV      采用ECB模式此参数无效，可置为NULL;CBC模式时为初始向量，16字节
     * @retval XKR_OK 成功
     */
    public native int SM1KEY(long hHandle, byte[] tmpkey, byte[] pDataIn, int dataLen, int flag, byte[] pDataOut, byte[] pIV);

    /**
     * @return 错误码
     * @brief 卡外SM4加解密（软算法），卡外送入密钥 (分组长度16)
     * @param[in] hHandle    设备句柄
     * @param[in] tmpkey     密钥，16字节
     * @param[in] pDataIn    输入数据，数据长度为16整数倍
     * @param[in] dataLen    输入数据长度
     * @param[in] flag       指示加密、解密与运算模式。
     * @param[out] pDataOut  输出数据
     * @param[in] pIV        采用ECB模式此参数无效，可置为NULL;CBC模式时为初始向量，16字节
     * @retval XKR_OK 成功
     */
    public native int SM4KEY(long hHandle, byte[] tmpkey, byte[] pDataIn, int dataLen, int flag, byte[] pDataOut, byte[] pIV);

    public native int SM4KEYEx(long hHandle, byte[] tmpkey, byte[] pDataIn, int dataLen, int flag, byte[] pDataOut, byte[] pIV);

    /**
     * @return 错误码
     * @brief SM6加解密（硬算法），卡外送入密钥 (分组长度16)
     * （SCB2）
     * @param[in] hHandle    设备句柄
     * @param[in] tmpkey     密钥，32字节
     * @param[in] pDataIn    输入数据，数据长度为16整数倍
     * @param[in] dataLen    输入数据长度
     * @param[in] flag       指示加密、解密与运算模式。
     * @param[out] pDataOut  输出数
     * @param[in] pIV        采用ECB模式此参数无效，可置为NULL;CBC模式时为初始向量，16字节
     * @retval XKR_OK 成功
     */
    public native int SM6KEY(long hHandle, byte[] tmpkey, byte[] pDataIn, int dataLen, int flag, byte[] pDataOut, byte[] pIV);

    /**
     * @return 错误码
     * @brief 卡内产生RSA密钥对
     * 条件：密钥对不出卡时要求有写指定公私钥文件的权限
     * @param[in] hHandle 设备句柄
     * @param[in] bits    RSA公钥模数长度，1024或2048
     * @param[in] pubfid  公钥文件ID，为0x00 0x00时表示公钥导出卡外
     * @param[in] prifid  私钥文件ID，公私钥文件ID均为0x00 0x00时私钥可导出卡外
     * @param[in] pPub    RSA公钥结构，公钥文件ID为0x00 0x00时有效
     * @param[in] pPri    RSA私钥结构，公私钥文件ID均为0x00 0x00时有效
     * @retval XKR_OK 成功
     */
    public native int GenRSAKeyPair(long hHandle, int bits, byte[] pubfid, byte[] prifid, RsaPublicKey pPub, RsaPrivateKey pPri);

    /**
     * @return 错误码
     * @brief RSA公钥运算 （RSA签名验证）
     * 传入数据填充或解填充由调用者进行
     * @param[in] hHandle   设备句柄
     * @param[in] fid       RSA公钥文件ID,为0x00 0x00时使用外部公钥
     * @param[in] pPub      RSA公钥结构，公钥文件ID为0x00 0x00时有效
     * @param[in] pDataIn   输入数据
     * @param[in] dlen      输入数据长度，RSA1024为128，RSA2048为256
     * @param[out] pDataOut  输出数据
     * @param[out] outLen    输出结果长度，128或256
     * @retval XKR_OK 成功
     */
    public native int RSAPubKeyCalc(long hHandle, byte[] fid, RsaPublicKey pPub, byte[] pDataIn, int dlen, byte[] pDataOut, int[] outLen);

    /**
     * @return 错误码
     * @brief RSA私钥运算 （RSA签名）
     * 传入数据由调用者进行填充。
     * @param[in] hHandle   设备句柄
     * @param[in] pin       pin码
     * @param[in] pinlen       pin密码
     * @param[in] pinrole   pin角色
     * @param[in] fid       私钥ID
     * @param[in] pDataIn   输入数据
     * @param[in] dlen      输入数据长度，RSA1024为128，RSA2048为256(暂不支持)
     * @param[out] pDataOut 输出数据
     * @param[out] outLen   输出结果长度，128或256
     * @retval XKR_OK        成功
     * @retval XKR_NO_POWER  权限不够
     */
    public native int RSAPriKeyCalc(long hHandle, byte[] fid, byte[] pDataIn, int dlen, byte[] pDataOut, int[] outLen);

    /**
     * @return 错误码
     * @brief RSA数据签名
     * @param[in] hHandle         设备句柄
     * @param[in] bits            RSA公钥模数 RSA1024为1024，RSA2048为2048，RSA1152为1152
     * @param[in] prikeyid        私钥ID
     * @param[in] datatype        数据类型，见SIGN_DATA_TYPE
     * @param[in] pDatain         输入数据
     * @param[in] dlen            输入数据长度，datatype=SIGN_HASH时，摘要数据长度必须为20；
     * @param[out] signData       输出签名数据
     * @param[out] outlen         输出数据长度 128或256
     * @retval XKR_OK        成功
     * @retval XKR_NO_POWER  权限不够
     */
    public native int RSASign(long hHandle, int bits, byte[] prikeyid, int datatype, byte[] pDatain, int dlen, byte[] signData, int[] outlen);


    /**
     * @return 错误码
     * @brief RSA数据签名验证
     * @param[in] hHandle         设备句柄
     * @param[in] bits            RSA公钥模数
     * @param[in] pubkeyid        公钥ID
     * @param[in] rsaPubkey       签名用公钥，当pubkeyid为0x00 0x00时使用
     * @param[in] datatype        数据类型，见SIGN_DATA_TYPE
     * @param[in] pDatain         输入数据
     * @param[in] dlen            输入数据长度，datatype=SIGN_HASH时，摘要数据长度必须为20；
     * @param[in] signData         验签数据
     * @retval XKR_OK 成功
     */
    public native int RSASignVerify(long hHandle, int bits, byte[] pubkeyid, RsaPublicKey rsaPubkey, int datatype, byte[] pDatain, int dlen, byte[] signData);

    /**
     * @return 错误码
     * @brief 设置SM2算法身份标识
     * @param[in] hHandle  设备句柄
     * @param[in] sm2id    身份标识
     * @param[in] dlen     身份标识长度
     * @retval XKR_OK 成功
     */
    public native int SetSM2Id(long hHandle, byte[] sm2id, int dlen);

    /**
     * @return 错误码
     * @brief 获取SM2算法身份标识
     * @param[in] hHandle   设备句柄
     * @param[out] sm2id     身份标识
     * @param[out] outlen    身份标识长度
     * @retval XKR_OK 成功
     */
    public native int GetSM2Id(long hHandle, byte[] sm2id, int[] outlen);

    /**
     * @return 错误码
     * @brief 设置SM2算法参数
     * @param[in] hHandle      设备句柄
     * @param[in] sm2param     参数结构体指针
     * @retval XKR_OK 成功
     */
    public native int SetSM2Param(long hHandle, Sm2Param sm2param);

    /**
     * @return 错误码
     * @brief 取得SM2算法参数
     * @param[in] hHandle     设备句柄
     * @param[out] sm2param   参数结构体指针
     * @retval XKR_OK 成功
     */
    public native int GetSM2Param(long hHandle, Sm2Param sm2param);

    /**
     * @return 错误码
     * @brief 生成SM2密钥对
     * @param[in] hHandle         设备句柄
     * @param[in] pubkeyid        公钥文件ID,为0x00 0x00时表示公钥导出卡外
     * @param[in] prikeyid        私钥文件ID,公私钥ID均为0x00 0x00时表示私钥导出卡外
     * @param[out] sm2pubkey      SM2公钥结构，公钥文件ID为0x00 0x00时有效
     * @param[out] sm2prikey      SM2私钥结构，公私钥文件ID均为0x00 0x00时有效
     * @retval XKR_OK 成功
     */
    public native int GenSM2KeyPair(long hHandle, byte[] pubkeyid, byte[] prikeyid, Sm2PublicKey sm2pubkey, Sm2PrivateKey sm2prikey);

    /**
     * @return 错误码
     * @brief SM2公钥加密
     * XDJA密文结构： 0x04 | x(32B) | y(32B) | 密文 | 明文HASH(32B)，即：0x04 C1 C2 C3
     * @param[in] hHandle         设备句柄
     * @param[in] pubkeyid        SM2公钥ID，两字节，第二个字节有效 ，为0x00 0x00表示公钥随数据传入
     * @param[in] sm2pubkey       公钥,当pubkeyid为0x00 0x00时有效
     * @param[in] pDatain         明文数据,最大长度不超过158
     * @param[in] dlen            数据长度
     * @param[out] pDataout       加密后密文,缓冲长度至少为dlen+97
     * @param[out] outlen         加密后数据长度
     * @retval XKR_OK 成功
     */
    public native int SM2Encrypt(long hHandle, byte[] pubkeyid, Sm2PublicKey sm2pubkey, byte[] pDatain, int dlen, byte[] pDataout, int[] outLen);

    public native int SM2EncryptGM(long hHandle, byte[] pubkeyid, Sm2PublicKey sm2pubkey, byte[] pDatain, int dlen, byte[] pDataout, int[] outLen);


    /**
     * @return 错误码
     * @brief SM2私钥解密
     * @param[in] hHandle         设备句柄
     * @param[in] prikeyid        SM2私钥ID 两字节，第二个字节有效
     * @param[in] pDatain         密文数据,最大长度不超过SM2_BLOCK_MAX+97,格式为：04 C1 C2 C3
     * @param[in] dlen            数据长度
     * @param[out] pDataout       解密后的明文数据,缓冲区至少为dlen-97
     * @param[out] outlen         解密后数据长度
     * @retval XKR_OK        成功
     * @retval XKR_NO_POWER  权限不够
     */
    public native int SM2Decrypt(long hHandle, byte[] prikeyid, byte[] pDatain, int dlen, byte[] pDataout, int[] outlen);

    public native int SM2DecryptGM(long hHandle, byte[] prikeyid, byte[] pDatain, int dlen, byte[] pDataout, int[] outlen);

    /**
     * @return 错误码
     * @brief SM2数据签名（软HASH）
     * 如果待签名数据已经SM3HASH，直接签名；否则先进行SM3HASH（软算法）
     * @param[in] hHandle         设备句柄
     * @param[in] pubkeyid        公钥ID,当datatype=1时,pubkeyid有效
     * @param[in] prikeyid        私钥ID
     * @param[in] datatype        数据类型,见SIGN_DATA_TYPE
     * @param[in] pDatain         输入数据
     * @param[in] dlen            数据长度,如果datatype=SIGN_HASH,数据长度必须为32，即e值
     * @param[out] signData       输出签名数据,缓冲区长度必须大于64字节，格式：32字节r+32字节s
     * @param[out] outlen         输出数据长度
     * @retval XKR_NO_POWER  权限不够
     * @retval XKR_OK 成功
     */
    public native int SM2Sign(long hHandle, byte[] pubkeyid, byte[] prikeyid, int datatype, byte[] pDatain, int dlen, byte[] signData, int[] outlen);

    public native int SM2SignEx(long hHandle, byte[] pubkeyid, byte[] prikeyid, byte[] pDatain, int dlen, byte[] signData, int[] outlen);

    /**
     * @return 错误码
     * @brief SM2数据签名验证（软HASH）
     * 如果待签名数据已经SM3HASH，直接验签；否则先进行SM3HASH（软算法）
     * @param[in] hHandle         设备句柄
     * @param[in] pubkeyid        公钥ID
     * @param[in] datatype        数据类型，见SIGN_DATA_TYPE
     * @param[in] sm2pubkey       签名用公钥，当pubkeyid为0x00 0x00时使用
     * @param[in] pDatain         数据
     * @param[in] dlen            数据长度，如果datatype=SIGN_HASH,数据长度必须为32，即e值
     * @param[in] signData        验签数据
     * @retval XKR_OK        成功
     */
    public native int SM2SignVerify(long hHandle, byte[] pubkeyid, int datatype, Sm2PublicKey sm2pubkey, byte[] pDatain, int dlen, byte[] signData);

    public native int SM2SignVerifyEx(long hHandle, byte[] pubkeyid, Sm2PublicKey sm2pubkey, byte[] pDatain, int dlen, byte[] signData);


    /**
     * @return 错误码
     * @brief SM2协商密钥初始化
     * @param[in] hHandle          设备句柄
     * @param[in] pubkeyid         SM2公钥ID 两字节,第二个字节有效,第一字节必须为0x00
     * @param[out] pdataout        产生协商数据
     * @param[out] outlen          输出数据长度
     * @retval XKR_OK 成功
     */
    public native int SM2KeyGenInit(long hHandle, byte[] pubkeyid, byte[] pdataout, int[] outlen);

    /**
     * @return 错误码
     * @brief SM2协商密钥 计算步骤
     * @param[in] hHandle          设备句柄
     * @param[in] pubkeyid         SM2公钥ID 两字节,第一节字必须为0x00,第二个字节有效 当dictflag=SM2_KEY_GENERATE_DICT_SEND 时 公钥ID为0x00x00
     * @param[in] prikeyid         SM2私钥ID 两字节,第一节字必须为0x00,第二个字节有效
     * @param[in] pDatain          输入数据
     * 当dictflag=SM2_KEY_GENERATE_DICT_SEND 时，输入数据为 响应方的ID（TLV格式）||响应方公钥x坐标（TLV格式）||响应方公钥y坐标（TLV格式）||响应方临时公钥x坐标（TLV格式）||响应方临时公钥y坐标(TLV格式)
     * 当dictflag=SM2_KEY_GENERATE_DICT_RECV 时，输入数据为 发起方的ID（TLV格式）||发起方公钥x坐标（TLV格式）||发起方公钥y坐标（TLV格式）||发起方临时公钥x坐标（TLV格式）||发起方临时公钥y坐标(TLV格式)
     * @param[in] dlen             输入数据长度
     * @param[out] pDataout        产生协商数据
     * @param[out] outlen          输出数据长度
     * @param[in] dictflag         发起对象,SM2_KEY_GENERATE_DICT_SEND为发起方,SM2_KEY_GENERATE_DICT_RECV为响应方]
     * @param[in] prikeyflag       密钥存储标记 1固定位置,0临时位置
     * @retval XKR_OK 成功
     */
    public native int SM2KeyGenCompute(long hHandle, byte[] pubkeyid, byte[] prikeyid, byte[] pDatain, int dlen, byte[] pDataout, int[] outlen, byte dictflag, byte keyflag);

    /**
     * @return 错误码
     * @brief SM2协商密钥验证
     * @param[in] hHandle         设备句柄
     * @param[in] pDatain         输入数据
     * @param[in] dlen            输入数据长度 固定32字节
     * @retval XKR_OK 成功
     */
    public native int SM2KeyGenVerify(long hHandle, byte[] pDatain, int dlen);

    /**
     * @return 错误码
     * @brief SHA1运算(软算法)
     * @param[in] hHandle  设备句柄
     * @param[in] pDataIn  输入数据
     * @param[in] dataLen    输入数据长度
     * @param[out] pDataOut 输出运算结果 20个字节
     * @retval XKR_OK 成功
     */
    public native int SHA1(long hHandle, byte[] pDataIn, int dataLen, byte[] pDataOut);

    /**
     * @return 错误码
     * @brief SM3运算(软算法)
     * @param[in] hHandle   设备句柄
     * @param[in] pDataIn   输入数据
     * @param[in] dataLen   输入数据长度
     * @param[out] pDataOut 输出运算结果 32字节
     * @retval XKR_OK 成功
     */
    public native int SM3(long hHandle, byte[] pDatain, int dataLen, byte[] pDataOut);

    public native int SM3Ex(long hHandle, byte[] pDatain, int dataLen, byte[] pDataOut);

    /**
     * @return 错误码
     * @brief 获取加密U盘指定分区的挂载路径
     * @param[in] hHandle 设备句柄
     * @param[in] type    分区类型，含普通区、加密区、高速盘分区三种
     * @param[out] path   返回该分区的挂载路径
     * @retval XKR_OK 成功
     */
    public native int GetUsbMountPath(long hHandle, int type, byte[] path);

    /**
     * @return 错误码
     * @brief 修改加密U盘FLASH读写模式
     * @param[in] hHandle 设备句柄
     * @param[in] mode    新的读写模式：普通区临时可写、临时只读、永久可写、永久只读，高速盘临时可写 共五种
     * @retval XKR_OK 成功
     */
    public native int SetUsbRWMode(long hHandle, int mode);


    public native int ReadUsbNormalSecs(int var1, int var2, short var3, byte[] var4);

    public native int WriteUsbNormalSecs(int var1, int var2, short var3, byte[] var4);

    public native int OpenUsbSecuZone(int var1, byte[] var2, int var3);

    public native int CloseUsbSecuZone(int var1);

    public native int ChgUsbSecuZonePin(int var1, byte[] var2, int var3, byte[] var4, int var5, int var6);

    public native int UnlockUsbSecuZone(int var1, byte[] var2, int var3, byte[] var4, int var5);

    public native int InitUsbHiddZone(int var1);

    public native int ExecUsbScsiCmd(int var1, byte[] var2, int var3, byte[] var4, int var5, byte[] var6, int[] var7);

    public native int If2gKey(int var1);

    public native int gKeySign(int var1, byte[] var2, byte[] var3, int var4, byte[] var5, int[] var6, int var7);

    public native int GetRemainPower(int var1, int[] var2);

    public native int GetTFMountPath(int var1, byte[] var2, int[] var3);

    public native int GetTFZoneSize(int var1, int[] var2);

    public native int ReadTFZone(int var1, int var2, byte[] var3, int var4);

    public native int WriteTFZone(int var1, int var2, byte[] var3, int var4);
}
