package com.xdja.SafeKey.utils.pool;

import com.xdja.SafeKey.JNIAPI;

import java.util.Iterator;
import java.util.Vector;

/**
 * @ClassName MiniPcieConnectionPool
 * @Description TODO
 * @Date 2020/5/16 17:58
 * @Author FengZhen
 */
public class MiniPcieConnectionPool {


    public JNIAPI jniapi = new JNIAPI();
    public int[] devEnum = new int[1];

    public int sm2Index = 0;
    public int maxhandle = 10;
    public int nowDev = 1;
    long[] handle = new long[1];

    public Vector<MiniPcieConnection> sm2unlock = new Vector<>();
    public Vector<MiniPcieConnection> sm2lock = new Vector<>();

    public Vector<MiniPcieConnection> calculateunlock = new Vector<>();
    public Vector<MiniPcieConnection> calculatelock = new Vector<>();

    private MiniPcieConnectionPool() {
        init();
    }

    private void init() {
        jniapi.EnumDev(JNIAPI.CT_USBDEV, devEnum);
        for (int i = 0; i < maxhandle; i++) {
            jniapi.OpenDev(sm2Index, handle);
            MiniPcieConnection miniPcieConnection = new MiniPcieConnection(true, handle[0], sm2Index);
            sm2unlock.add(miniPcieConnection);
        }
        for (int i = 0; i < devEnum[0]; i++) {
            if (i == sm2Index) {
                continue;
            }
            for (int k = 0; k < maxhandle; k++) {
                jniapi.OpenDev(i, handle);
                MiniPcieConnection miniPcieConnection = new MiniPcieConnection(false, handle[0], i);
                calculateunlock.add(miniPcieConnection);
            }
        }
    }

    public synchronized MiniPcieConnection getSm2Handle() {
        MiniPcieConnection t = getMiniPcieConnection(sm2unlock, sm2lock);
        if (t != null) return t;
        // 对象池没有可用对象，创建新对象
        t = sm2Create();
        sm2lock.add(t);
        return (t);
    }

    private synchronized MiniPcieConnection sm2Create() {
        jniapi.EnumDev(JNIAPI.CT_USBDEV, devEnum);
        long[] handle = new long[1];
        jniapi.OpenDev(sm2Index, handle);
        return new MiniPcieConnection(true, handle[0], 0);
    }


    public synchronized MiniPcieConnection getCalculateHandle() {
        MiniPcieConnection t1 = getMiniPcieConnection(calculateunlock, calculatelock);
        if (t1 != null) return t1;
        MiniPcieConnection t;
        // 对象池没有可用对象，创建新对象
        if (nowDev >= devEnum[0]) {
            nowDev = 0;
        }
        if (nowDev == sm2Index) {
            nowDev++;
        }
        t = calculateCreate(nowDev);
        nowDev++;
        calculateunlock.add(t);
        return (t);
    }

    private MiniPcieConnection getMiniPcieConnection(Vector<MiniPcieConnection> unlock, Vector<MiniPcieConnection> lock) {
        MiniPcieConnection t;
        if (unlock.size() > 0) {
            Iterator<MiniPcieConnection> iter = unlock.iterator();
            while (iter.hasNext()) {
                t = iter.next();
                if (t.isValid(jniapi)) {
                    // 对象有效
                    unlock.remove(t);
                    lock.add(t);
                    return t;
                } else {   // 对象已经失效
                    unlock.remove(t);
                    closeHandle(t);
                }
            }
        }
        return null;
    }

    private synchronized MiniPcieConnection calculateCreate(int index) {
        jniapi.EnumDev(JNIAPI.CT_USBDEV, devEnum);
        jniapi.OpenDev(index, handle);
        return new MiniPcieConnection(true, handle[0], index);
    }

    public void closeHandle(MiniPcieConnection connection) {
        try {
            jniapi.CloseDev(connection.getHandle());
            if (connection.isSM2Handle()) {
                sm2lock.remove(connection);
            } else {
                calculatelock.remove(connection);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            connection = null;
        }
    }

    public synchronized void release(MiniPcieConnection connection) {
        try {
            if (connection.isSM2Handle()) {
                sm2lock.remove(connection);
                sm2unlock.add(connection);
            } else {
                calculatelock.remove(connection);
                calculateunlock.add(connection);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            connection = null;
        }
    }

    private static class MiniPcieConnectionPoolLoader {
        private static final MiniPcieConnectionPool INSTANCE = new MiniPcieConnectionPool();
    }

    public static MiniPcieConnectionPool getInstance() {
        return MiniPcieConnectionPoolLoader.INSTANCE;
    }
}
