//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.xdja.SafeKey;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLECUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.util.encoders.Hex;

import java.security.PrivateKey;
import java.util.Arrays;

public class Sm2PrivateKey {
    private byte[] d = new byte[32];

    public Sm2PrivateKey() {
    }

    public Sm2PrivateKey(byte[] d) {
        this.d = d;
    }

    public Sm2PrivateKey(PrivateKey privateKey) {
        BCECPrivateKey bcecPrivateKey = (BCECPrivateKey) privateKey;
        this.d = GMSSLByteArrayUtils.filterByteArrayZeroInHead(bcecPrivateKey.getD().toByteArray(), 32);
    }

    public byte[] getD() {
        return d;
    }

    public void setD(byte[] d) {
        this.d = d;
    }

    public PrivateKey getPrivateKey(String stdName) throws Exception {
        return GMSSLECUtils.convertECPrivateKey(d, stdName);
    }

    @Override
    public String toString() {
        return "Sm2PrivateKey{" +
                "d=" + Hex.toHexString(d) +
                '}';
    }
}
