package com.xdja.SafeKey.utils;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import org.bouncycastle.util.encoders.Hex;
import sun.net.www.content.text.plain;

/**
 * @ClassName MiniPcieSymmetricEncryptUtils
 * @Description TODO
 * @Date 2020/5/20 11:05
 * @Author FengZhen
 */
public class MiniPcieSymmetricEncryptUtils {

    public static byte[] sm1EcbWithPkcs5Padding(byte[] key, byte[] data, boolean isEncrypt) throws Exception {
        return sm1EcbWithPkcs7Padding(key, data, isEncrypt);
    }

    public static byte[] sm1EcbWithPkcs7Padding(byte[] key, byte[] data, boolean isEncrypt) throws Exception {
        if (isEncrypt) {
            byte[] paddingData = GMSSLX509Utils.paddingData(data, true);
            return MiniPcieXKFUtils.sm1(key, paddingData, JNIAPI.ECB_ENCRYPT, null);
        } else {
            byte[] plainText = MiniPcieXKFUtils.sm1(key, data, JNIAPI.ECB_DECRYPT, null);
            return GMSSLX509Utils.removePadding(data, plainText, true);
        }
    }

    public static byte[] sm1EcbWithSslv3Padding(byte[] key, byte[] data, boolean isEncrypt) throws Exception {
        if (isEncrypt) {
            byte[] paddingData = GMSSLX509Utils.paddingData(data, false);
            return MiniPcieXKFUtils.sm1(key, paddingData, JNIAPI.ECB_ENCRYPT, null);
        } else {
            byte[] plainText = MiniPcieXKFUtils.sm1(key, data, JNIAPI.ECB_DECRYPT, null);
            return GMSSLX509Utils.removePadding(data, plainText, false);
        }
    }

    public static byte[] sm4EcbWithPkcs5Padding(byte[] key, byte[] data, boolean isEncrypt) throws Exception {
        return sm4EcbWithPkcs7Padding(key, data, isEncrypt);
    }

    public static byte[] sm4EcbWithPkcs7Padding(byte[] key, byte[] data, boolean isEncrypt) throws Exception {
        if (isEncrypt) {
            byte[] paddingData = GMSSLX509Utils.paddingData(data, true);
            return MiniPcieXKFUtils.sm4(key, paddingData, JNIAPI.ECB_ENCRYPT, null);
        } else {
            byte[] plainText = MiniPcieXKFUtils.sm4(key, data, JNIAPI.ECB_DECRYPT, null);
            return GMSSLX509Utils.removePadding(data, plainText, true);
        }
    }

    public static byte[] sm4EcbWithSslv3Padding(byte[] key, byte[] data, boolean isEncrypt) throws Exception {
        if (isEncrypt) {
            byte[] paddingData = GMSSLX509Utils.paddingData(data, false);
            return MiniPcieXKFUtils.sm4(key, paddingData, JNIAPI.ECB_ENCRYPT, null);
        } else {
            byte[] plainText = MiniPcieXKFUtils.sm4(key, data, JNIAPI.ECB_DECRYPT, null);
            return GMSSLX509Utils.removePadding(data, plainText, false);
        }
    }


    public static byte[] sm1CbcWithPkcs5Padding(byte[] key, byte[] data, byte[] iv, boolean isEncrypt) throws Exception {
        return sm1CbcWithPkcs7Padding(key, data, iv, isEncrypt);
    }

    public static byte[] sm1CbcWithPkcs7Padding(byte[] key, byte[] data, byte[] iv, boolean isEncrypt) throws Exception {
        if (isEncrypt) {
            byte[] paddingData = GMSSLX509Utils.paddingData(data, true);
            System.out.println(Hex.toHexString(paddingData));
            return MiniPcieXKFUtils.sm1(key, paddingData, JNIAPI.CBC_ENCRYPT, iv);
        } else {
            byte[] plainText = MiniPcieXKFUtils.sm1(key, data, JNIAPI.CBC_DECRYPT, iv);
            return GMSSLX509Utils.removePadding(data, plainText, true);
        }
    }

    public static byte[] sm1CbcWithSslv3Padding(byte[] key, byte[] data, byte[] iv, boolean isEncrypt) throws Exception {
        if (isEncrypt) {
            byte[] paddingData = GMSSLX509Utils.paddingData(data, false);
            return MiniPcieXKFUtils.sm1(key, paddingData, JNIAPI.CBC_ENCRYPT, iv);
        } else {
            byte[] plainText = MiniPcieXKFUtils.sm1(key, data, JNIAPI.CBC_DECRYPT, iv);
            return GMSSLX509Utils.removePadding(data, plainText, false);
        }
    }

    public static byte[] sm4CbcWithPkcs5Padding(byte[] key, byte[] data, byte[] iv, boolean isEncrypt) throws Exception {
        return sm4CbcWithPkcs7Padding(key, data, iv, isEncrypt);
    }

    public static byte[] sm4CbcWithPkcs7Padding(byte[] key, byte[] data, byte[] iv, boolean isEncrypt) throws Exception {
        if (isEncrypt) {
            byte[] paddingData = GMSSLX509Utils.paddingData(data, true);
            return MiniPcieXKFUtils.sm4(key, paddingData, JNIAPI.CBC_ENCRYPT, iv);
        } else {
            byte[] plainText = MiniPcieXKFUtils.sm4(key, data, JNIAPI.CBC_DECRYPT, iv);
            return GMSSLX509Utils.removePadding(data, plainText, true);
        }
    }

    public static byte[] sm4CbcWithSslv3Padding(byte[] key, byte[] data, byte[] iv, boolean isEncrypt) throws Exception {
        if (isEncrypt) {
            byte[] paddingData = GMSSLX509Utils.paddingData(data, false);
            return MiniPcieXKFUtils.sm4(key, paddingData, JNIAPI.CBC_ENCRYPT, iv);
        } else {
            byte[] plainText = MiniPcieXKFUtils.sm4(key, data, JNIAPI.CBC_DECRYPT, iv);
            return GMSSLX509Utils.removePadding(data, plainText, false);
        }
    }

}
