package com.xdja.SafeKey;

/**
 * @ClassName XkfApiCode
 * @Description TODO
 * @Date 2020/5/16 21:57
 * @Author FengZhen
 */
public enum XkfApiCode {

    XKR_OK(0, "成功"),

    XKR_PWD_1(1, "口令错误, 剩余1重试机会"),
    XKR_PWD_2(2, "口令错误, 剩余1重试机会"),
    XKR_PWD_3(3, "口令错误, 剩余3重试机会"),
    XKR_PWD_4(4, "口令错误, 剩余4重试机会"),
    XKR_PWD_5(5, "口令错误, 剩余5重试机会"),

    XKR_NO_HANDLE(-1, "指定的句柄不存在"),

    XKR_IO_FAILED(-2, "通过卡接口收发数据失败"),

    XKR_BACK_LENGTH(-3, "返回数据之长度错误"),

    XKR_BACK_DATA(-4, "返回数据错误"),

    XKR_RESET_FAILED(-5, "卡重置失败"),

    XKR_NO_ROLE(-6, "指定的角色不存在"),

    XKR_DATAIN_SIZE(-7, "输入数据的长度不合适"),

    XKR_OUTBUF_SIZE(-8, "指定的数据接收缓冲区大小不合适"),

    XKR_INVALID_PARA(-9, "接口参数错误"),

    XKR_PASSWORD(-10, "口令错误, 剩余重试次数为0"),

    XKR_EEPROM_WRITE(-11, "EEPROM写入错误"),

    XKR_PARAMETER(-12, "COS指令参数错误"),

    XKR_CMD_NOTMATCH_LINE(-13, "命令与线路保护不适应"),

    XKR_CMD_NOTMATCH_FAT(-14, "命令与文件结构不相容"),

    XKR_NO_POWER(-15, "权限不够"),

    XKR_KEY_LOCKED(-16, "密钥被锁死"),

    XKR_DATA_PARAMETER(-18, "数据域参数错误"),

    XKR_APP_LOCKED(-19, "应用锁定"),

    XKR_FILE_NOT_EXIST(-20, "文件不存在"),

    XKR_NO_FILE_SPACE(-21, "文件无足够空间"),

    XKR_NOT_GET_RANDOM(-22, "未取随机数"),

    XKR_FILE_EXIST(-23, "文件已存在"),

    XKR_FILE_CONTENT(-24, "文件内容错误"),

    XKR_WRONG_STATE(-25, "错误的状态"),

    XKR_CARD_LOCKED(-26, "卡锁定"),

    XKR_WRONG_LE(-27, "Le错误"),

    XKR_NO_THIS_CMD(-28, "命令不存在"),

    XKR_INVALID_DATA(-29, "数据无效"),

    XKR_WRONG_MAC(-30, "MAC错误"),

    XKR_KEYFILE_NOT_EXIST(-31, "密钥文件不存在"),

    XKR_KEY_NOT_EXIST(-32, "密钥不存在"),

    XKR_WRONG_KEY_TYPE(-33, "密钥类型不对"),

    XKR_BAD_PUBKEY(-34, "返回公钥内容格式不对"),

    XKR_HASH_FAILED(-35, "HASH运算失败"),

    XKR_RSAPUBLIC_FAILED(-36, "RSA公钥运算失败"),

    XKR_BAD_PRIKEY(-37, "返回私钥内容格式不对"),

    XKR_SIGN_CONFIRM(-38, "等待用户签名确认"),

    XKR_SIGN_CANCEL(-39, "用户签名确认取消"),

    XKR_CONDITION(-40, "使用条件不满足"),

    XKR_DECRYPT_FAIL(-41, "解密失败"),

    XKR_NOT_FIND_DATA(-42, "文件偏移地址超出，即未找到数据"),

    XKR_DGI_NOT_SUPPORT(-43, "DGI不支持"),

    XKR_DATA_NOCORRENT(-44, "安全报文数据对象不正确"),

    XKR_EXAUTH_FAIL(-45, "外部认证失败"),

    XKR_RSA_NOT_FIND(-46, "RSA密钥未找到"),

    XKR_TLOCK_FAILD(-47, "创建事务锁失败"),

    XKR_TLOCK_TIMEOUT(-48, "事务锁超时"),

    XKR_BAD_CERT(-49, "证书内容错误"),

    XKR_SIGN_VERIFY(-50, "签名验证失败"),

    XKR_GETMOUNTPATH_FAILD(-51, "获取盘符/挂载路径失败"),

    XKR_MALLOC_FALID(-95, "内存申请失败"),

    XKR_BUFFERISNULL(-96, "内存为空"),

    XKR_NO_KEY(-97, "未插入安全卡"),

    XKR_NOT_SUPPORT(-98, "暂不支持"),

    XKR_NOT_ACTIVATED(-99, "卡未激活, 需先激活才能正常使用"),

    XKR_UNKNOWN(-100, "未知错误"),

    XKR_FP_QUERYWAITE(-101, "未查询到指纹状态，请等待"),

    XKR_FP_CONDITION_NOTMET(-102, "指纹KEY使用条件不满足"),

    XKR_FP_NOT_MATCH(-103, "指纹验证不匹配"),

    XKR_FP_RECV_CANCEL(-104, "收到取消请求"),

    XKR_FP_INVALID(-105, "检测到非指纹"),

    XKR_FP_VALID(-106, "检测到有效指纹"),

    XKR_FP_WAITE_ENROLL(-107, "等待指纹录入"),

    XKR_FP_ENROLLING(-108, "当前正在进行指纹录入操作，如需执行其它指令，需发送取消指令"),

    XKR_FP_VERIFYING(-109, "当前正在进行指纹验证操作，如需执行其它指令，需发送取消指令"),

    XKR_FP_NOROOM(-110, "指纹存储器空间不足"),

    XKR_FP_NOSTORE(-111, "设备不存在有效指纹"),

    XKR_FP_CHECKFAILED(-112, "未检测到指纹，非中间状态，需要重新发起录入/验证");

    private int code;
    private String txt;

    XkfApiCode(int code, String txt) {
        this.code = code;
        this.txt = txt;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getTxt() {
        return txt;
    }

    public void setTxt(String txt) {
        this.txt = txt;
    }

    public static String getErrorMessage(int index)  {
        for (XkfApiCode t : XkfApiCode.values()) {
            if (t.code == index) {
                return t.txt;
            }
        }
        throw new IllegalArgumentException(String.format("XkfApiCode 枚举转换异常[id=%d]", index));
    }
}
