package com.xdja.SafeKey.bean;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import org.bouncycastle.util.BigIntegers;

import java.math.BigInteger;

/**
 * @ClassName MiniPcieIndexEnum
 * @Description TODO
 * @Date 2020/5/20 8:48
 * @Author FengZhen
 */
public enum MiniPcieIndexEnum {
    ONE(1, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e),

    TWO(2, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35);

    public int index;
    public int containerIndex;
    public int encCertIndex;
    public int encPublicKeyIndex;
    public int encPrivateIndex;
    public int signCertIndex;
    public int signPublicKeyIndex;
    public int signPrivateIndex;

    MiniPcieIndexEnum(int index, int containerIndex, int encCertIndex, int encPublicKeyIndex, int encPrivateIndex, int signCertIndex, int signPublicKeyIndex, int signPrivateIndex) {
        this.index = index;
        this.containerIndex = containerIndex;
        this.encCertIndex = encCertIndex;
        this.encPublicKeyIndex = encPublicKeyIndex;
        this.encPrivateIndex = encPrivateIndex;
        this.signCertIndex = signCertIndex;
        this.signPublicKeyIndex = signPublicKeyIndex;
        this.signPrivateIndex = signPrivateIndex;
    }

    public static MiniPcieIndexEnum getInfoFromIndex(int index) {
        for (MiniPcieIndexEnum t : MiniPcieIndexEnum.values()) {
            if (t.index == index) {
                return t;
            }
        }
        throw new IllegalArgumentException(String.format("MiniPcieIndexEnum 枚举转换异常[id=%d]", index));
    }

    public byte[] getEncCertIndex() {
        return GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(BigIntegers.asUnsignedByteArray(BigInteger.valueOf(encCertIndex)), 2);
    }

    public byte[] getEncPublicKeyIndex() {
        return GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(BigIntegers.asUnsignedByteArray(BigInteger.valueOf(encPublicKeyIndex)), 2);
    }

    public byte[] getEncPrivateIndex() {
        return GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(BigIntegers.asUnsignedByteArray(BigInteger.valueOf(encPrivateIndex)), 2);
    }

    public byte[] getSignCertIndex() {
        return GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(BigIntegers.asUnsignedByteArray(BigInteger.valueOf(signCertIndex)), 2);
    }

    public byte[] getSignPublicKeyIndex() {
        return GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(BigIntegers.asUnsignedByteArray(BigInteger.valueOf(signPublicKeyIndex)), 2);
    }

    public byte[] getSignPrivateIndex() {
        return GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(BigIntegers.asUnsignedByteArray(BigInteger.valueOf(signPrivateIndex)), 2);
    }
}
