package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.Enumerated;
import org.bouncycastle.util.BigIntegers;

import java.math.BigInteger;

/***
 * AuthorizationResponseCode ::= ENUMERATED {
 ok(0),
 -- ITS->AA
 its-aa-cantparse, -- valid for any structure
 its-aa-badcontenttype, -- not encrypted, not signed, not authorizationrequest
 its-aa-imnottherecipient, -- the "recipients" of the outermost encrypted data doesn't
 include me
 its-aa-unknownencryptionalgorithm, -- either kexalg or contentencryptionalgorithm
 its-aa-decryptionfailed, -- works for ECIES-HMAC and AES-CCM
 its-aa-keysdontmatch, -- HMAC keyTag verification fails
 its-aa-incompleterequest, -- some elements are missing
 its-aa-invalidencryptionkey, -- the responseEncryptionKey is bad
 its-aa-outofsyncrequest, -- signingTime is outside acceptable limits
 its-aa-unknownea, -- the EA identified by eaId is unknown to me
 its-aa-invalidea, -- the EA certificate is revoked
 its-aa-deniedpermissions, -- I, the AA, deny the requested permissions
 -- AA->EA
 aa-ea-cantreachea, -- the EA is unreachable (network error?)
 -- EA->AA
 ea-aa-cantparse, -- valid for any structure
 ea-aa-badcontenttype, -- not encrypted, not signed, not authorizationrequest
 ea-aa-imnottherecipient, -- the "recipients" of the outermost encrypted data doesn't
 include me
 ea-aa-unknownencryptionalgorithm, -- either kexalg or contentencryptionalgorithm
 ea-aa-decryptionfailed, -- works for ECIES-HMAC and AES-CCM
 -- TODO: to be continued...
 invalidaa, -- the AA certificate presented is invalid/revoked/whatever
 invalidaasignature, -- the AA certificate presented can't validate the request
 signature
 wrongea, -- the encrypted signature doesn't designate me as the EA
 unknownits, -- can't retrieve the EC/ITS in my DB
 invalidsignature, -- signature verification of the request by the EC fails
 invalidencryptionkey, -- signature is good, but the key is bad
 deniedpermissions, -- permissions not granted
 deniedtoomanycerts, -- parallel limit
 ... }
 */
public class BATCAuthorizationResponseCode extends Enumerated {
    public static final Enumerated.Value OK = new Value(0, "ok");
    // -- ITS->AA
    public static final Value ITS_AA_CANT_PRASE = new Value(1, " its-aa-cantparse");
    public static final Value ITS_AA_BAD_CONTENTTYPE = new Value(2, "its-aa-badcontenttype");
    public static final Value ITS_AA_IMONTTHERE_CIPIENT = new Value(3, "its-aa-imnottherecipient");
    public static final Value ITS_AA_UNKNOW_ENCRYPTION_ALGORITHM = new Value(4, "its-aa-unknownencryptionalgorithm");
    public static final Value ITS_AA_DECRYPTION_FAILED = new Value(5, "its-aa-decryptionfailed");
    public static final Value ITS_AA_KEYSDONTMATCH = new Value(6, "its-aa-keysdontmatch");
    public static final Value ITS_AA_INCOMPLETEREQUEST = new Value(7, "its-aa-incompleterequest");
    public static final Value ITS_AA_INVALIDENCRYPTIONKEY = new Value(8, "its-aa-invalidencryptionkey");
    public static final Value ITS_AA_OUTOFSYNCREQUEST = new Value(9, "its-aa-outofsyncrequest");
    public static final Value ITS_AA_UNKNOWEA = new Value(10, "its-aa-unknownea");
    public static final Value ITS_AA_INVALIDEA = new Value(11, "its-aa-invalidea");
    public static final Value ITS_AA_DENIEDPERMISSIONS = new Value(12, "its-aa-deniedpermissions");
    // -- AA->EA
    //          aa-ea-cantreachea, -- the EA is unreachable (network error?)
    public static final Value AA_EA_CANTREACHEA = new Value(13, "aa-ea-cantreachea");
    // -- EA->AA
    public static final Value EE_AA_CANT_PRASE = new Value(14, "ea-aa-cantparse");
    public static final Value EE_AA_BAD_CONTENTTYPE = new Value(15, "ee-aa-badcontenttype");
    public static final Value EE_AA_IMONTTHERE_CIPIENT = new Value(16, "ee-aa-imnottherecipient");
    public static final Value EE_AA_UNKNOW_ENCRYPTION_ALGORITHM = new Value(17, "ee-aa-unknownencryptionalgorithm");
    public static final Value EE_AA_DECRYPTION_FAILED = new Value(18, "ee-aa-decryptionfailed");
    public static final Value INVALID_AA = new Value(19, "invalidaa");
    public static final Value INVALID_AA_SIGNATURE = new Value(20, "invalidaasignature");
    public static final Value WRONGEA = new Value(21, "wrongea");
    public static final Value UNKNOWN_ITS = new Value(22, "unknownits");
    public static final Value INVALID_SIGNATURE = new Value(23, "invalidsignature");
    public static final Value INVALID_ENCRYPTION_KEY = new Value(24, "invalidencryptionkey");
    public static final Value DENIED_PERMISSIONS = new Value(25, "deniedpermissions");
    public static final Value DENIED_TOO_MANY_CERTS = new Value(26, "deniedtoomanycerts");


    public BATCAuthorizationResponseCode(Value value) {
        super(value);
        this.addValueToList(OK);
        this.addValueToList(ITS_AA_CANT_PRASE);
        this.addValueToList(ITS_AA_BAD_CONTENTTYPE);
        this.addValueToList(ITS_AA_IMONTTHERE_CIPIENT);
        this.addValueToList(ITS_AA_UNKNOW_ENCRYPTION_ALGORITHM);
        this.addValueToList(ITS_AA_DECRYPTION_FAILED);
        this.addValueToList(ITS_AA_KEYSDONTMATCH);
        this.addValueToList(ITS_AA_INCOMPLETEREQUEST);
        this.addValueToList(ITS_AA_INVALIDENCRYPTIONKEY);
        this.addValueToList(ITS_AA_OUTOFSYNCREQUEST);
        this.addValueToList(ITS_AA_UNKNOWEA);
        this.addValueToList(ITS_AA_INVALIDEA);
        this.addValueToList(ITS_AA_DENIEDPERMISSIONS);
        this.addValueToList(AA_EA_CANTREACHEA);
        this.addValueToList(EE_AA_CANT_PRASE);
        this.addValueToList(EE_AA_BAD_CONTENTTYPE);
        this.addValueToList(EE_AA_IMONTTHERE_CIPIENT);
        this.addValueToList(EE_AA_UNKNOW_ENCRYPTION_ALGORITHM);
        this.addValueToList(EE_AA_DECRYPTION_FAILED);
        this.addValueToList(INVALID_AA);
        this.addValueToList(INVALID_AA_SIGNATURE);
        this.addValueToList(WRONGEA);
        this.addValueToList(UNKNOWN_ITS);
        this.addValueToList(INVALID_SIGNATURE);
        this.addValueToList(INVALID_ENCRYPTION_KEY);
        this.addValueToList(DENIED_PERMISSIONS);
        this.addValueToList(DENIED_TOO_MANY_CERTS);
    }


    public static BATCAuthorizationResponseCode getInstance(byte[] data) throws Exception {
        //获取选择位置
        BigInteger choice = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        //枚举值判断
        Value value = BATCResponseCodeEnum.AuthorizationResponseCode.getValue(choice.intValue());
        BATCAuthorizationResponseCode responseCode = new BATCAuthorizationResponseCode(value);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        responseCode.setGoal(goal);
        return responseCode;
    }
}
