package com.xdja.pki.oer.batc;


import com.xdja.pki.oer.base.Sequence;

import java.util.Vector;

/***
 * AuthorizationValidationRequest ::= SEQUENCE {
 * sharedAtRequest		SharedAtRequest
 * ecSignature		EcSignature
 * })
 */
public class BATCAuthorizationValidationRequest extends Sequence {
    private BATCSharedAtRequest sharedAtRequest;
    private BATCEcSignature ecSignature;

    public BATCAuthorizationValidationRequest() {
        super(false, false);
    }

    public static BATCAuthorizationValidationRequest getInstance(byte[] data) throws Exception {
        BATCAuthorizationValidationRequest request = new BATCAuthorizationValidationRequest();
        //sharedAtRequest
        BATCSharedAtRequest sharedAtRequest = BATCSharedAtRequest.getInstance(data);
        data = sharedAtRequest.getGoal();
        //ecSignature
        BATCEcSignature ecSignature = BATCEcSignature.getInstance(data);
        request.setEcSignature(ecSignature);
        request.setSharedAtRequest(sharedAtRequest);
        request.setGoal(ecSignature.getGoal());
        return request;
    }

    public BATCSharedAtRequest getSharedAtRequest() {
        return sharedAtRequest;
    }

    public void setSharedAtRequest(BATCSharedAtRequest sharedAtRequest) {
        this.sharedAtRequest = sharedAtRequest;
    }

    public BATCEcSignature getEcSignature() {
        return ecSignature;
    }

    public void setEcSignature(BATCEcSignature ecSignature) {
        this.ecSignature = ecSignature;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(sharedAtRequest);
        vector.add(ecSignature);
        return vector;
    }
}
