package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.gbt.asn1.SecuredMessage;

/**
 * AuthorizationValidationRequestEnc ::= SecuredMessage(WITH COMPONENTS { ...,
 * 	version(2),
 * 	payload(WITH COMPONENTS { ...,
 * 		encData(WITH COMPONENTS { ...,
 * 			recipients(SequenceOfRecipientInfo (SIZE(1)) (CONSTRAINED BY {
 * 				RecipientInfo(WITH COMPONENTS {
 * 					certRecipInfo	--使用ECA证书加密公钥进行加密
 *                                })* 			})),
 * 			cipherText  --支持 sm4Ecb、aesCcm 两种。SymmetricCipher        t
 *            })
 * 	})
 * })
 * @author wzs
 * @version v1.0
 * @ClassName BATCAuthorizationValidationRequestEnc
 * @Date 2020/02/16 11:19
 */
public class BATCAuthorizationValidationRequestEnc extends SecuredMessage {
    public static BATCAuthorizationValidationRequestEnc getInstance(byte[] data) throws Exception {
        SecuredMessage instance = SecuredMessage.getInstance(data);
        BATCAuthorizationValidationRequestEnc validationRequestEnc = new BATCAuthorizationValidationRequestEnc();
        validationRequestEnc.setPayload(instance.getPayload());
        validationRequestEnc.setVersion(instance.getVersion());
        validationRequestEnc.setGoal(instance.getGoal());
        return validationRequestEnc;
    }
}
