package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.BitByte;
import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.base.Sequence;
import org.bouncycastle.util.BigIntegers;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/***
 * AuthorizationValidationResponse::= SEQUENCE {
 * requestHash					OctetString（SIZE（16））--- 请求的hash取前16字节
 * responseCode				AuthorizationValidationResponseCode 						--- 状态码 0成功
 * confirmedSubjectAttributes	CertificateSubjectAttributes (WITH COMPONENTS{...,
 * certIssuePermissions ABSENT})   OPTIONAL
 * ...
 * })(WITH COMPONENTS { responseCode (ok), confirmedSubjectAttributes PRESENT }
 * | WITH COMPONENTS { responseCode (ALL EXCEPT ok), confirmedSubjectAttributes ABSENT }
 * )
 */
public class BATCAuthorizationValidationResponse extends Sequence {
    private OctetString requestHash;
    private BATCAuthorizationValidationResponseCode responseCode;
    private BATCCertificateSubjectAttributes confirmedSubjectAttributes;


    public BATCAuthorizationValidationResponse() {
        super(true, true);
    }

    public static BATCAuthorizationValidationResponse getInstance(byte[] data) throws Exception {
        BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        List<Integer> integers = BitByte.setBit(integer.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        BATCAuthorizationValidationResponse response = new BATCAuthorizationValidationResponse();
        //requestHash
        OctetString requestHash = OctetString.getInstance(data, 16);
        data = requestHash.getGoal();
        //responseCode
        BATCAuthorizationValidationResponseCode responseCode = BATCAuthorizationValidationResponseCode.getInstance(data);
        data = responseCode.getGoal();
        //confirmedSubjectAttributes
        if (integers.contains(0)) {
            //可扩展
        }
        if (integers.contains(1)) {
            BATCCertificateSubjectAttributes confirmedSubjectAttributes = BATCCertificateSubjectAttributes.getInstance(data);
            response.setConfirmedSubjectAttributes(confirmedSubjectAttributes);
            data = confirmedSubjectAttributes.getGoal();
        }
        response.setRequestHash(requestHash);
        response.setResponseCode(responseCode);
        response.setGoal(data);
        return response;
    }

    public OctetString getRequestHash() {
        return requestHash;
    }

    public void setRequestHash(OctetString requestHash) {
        this.requestHash = requestHash;
    }

    public BATCAuthorizationValidationResponseCode getResponseCode() {
        return responseCode;
    }

    public void setResponseCode(BATCAuthorizationValidationResponseCode responseCode) {
        this.responseCode = responseCode;
    }

    public BATCCertificateSubjectAttributes getConfirmedSubjectAttributes() {
        return confirmedSubjectAttributes;
    }

    public void setConfirmedSubjectAttributes(BATCCertificateSubjectAttributes confirmedSubjectAttributes) {
        this.confirmedSubjectAttributes = confirmedSubjectAttributes;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        List<Integer> optionals = new ArrayList<>();
        if (this.confirmedSubjectAttributes != null) {
            optionals.add(7);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(requestHash);
        vector.add(responseCode);
        vector.add(confirmedSubjectAttributes);
        return vector;
    }
}
