package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.Enumerated;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;

/***
 AuthorizationValidationResponseCode ::= ENUMERATED {
     ok(0),
     cantparse, -- valid for any structure
     badcontenttype, -- not encrypted, not signed, not permissionsverificationrequest
     imnottherecipient, -- the "recipients" of the outermost encrypted data doesn't include
     ---me
     unknownencryptionalgorithm, -- either kexalg or contentencryptionalgorithm
     decryptionfailed, -- works for ECIES-HMAC and AES-CCM
     invalidaa, -- the AA certificate presented is invalid/revoked/whatever
     invalidaasignature, -- the AA certificate presented can't validate the request
     **---signature
     wrongea, -- the encrypted signature doesn't designate me as the EA
     unknownits, -- can't retrieve the EC/ITS in my DB
     invalidsignature, -- signature verification of the request by the EC fails
     invalidencryptionkey, -- signature is good, but the responseEncryptionKey is bad
     deniedpermissions, -- requested permissions not granted
     deniedtoomanycerts, -- parallel limit
     deniedrequest, -- any other reason?
 ...
 }
 */
public class BATCAuthorizationValidationResponseCode extends Enumerated {
    private static Logger logger = LoggerFactory.getLogger(BATCAuthorizationValidationResponseCode.class);

    public static final Enumerated.Value OK = new Value(0, "ok");
    public static final Value CANT_PRASE = new Value(1, "cantparse");
    public static final Value BAD_CONTENTTYPE = new Value(2, "badcontenttype");
    public static final Value IMONTTHERE_CIPIENT = new Value(3, "imnottherecipient");
    public static final Value UNKNOW_ENCRYPTION_ALGORITHM = new Value(4, "unknownencryptionalgorithm");
    public static final Value DECRYPTION_FAILED = new Value(5, "decryptionfailed");
    public static final Value INVALID_AA = new Value(6, "invalidaa");
    public static final Value INVALID_AA_SIGNATURE = new Value(7, "invalidaasignature");
    public static final Value WRONGEA = new Value(8, "wrongea");
    public static final Value UNKNOWN_ITS = new Value(9, "unknownits");
    public static final Value INVALID_SIGNATURE = new Value(10, "invalidsignature");
    public static final Value INVALID_ENCRYPTION_KEY = new Value(11, "invalidencryptionkey");
    public static final Value DENIED_PERMISSIONS = new Value(12, "deniedpermissions");
    public static final Value DENIED_TOO_MANY_CERTS = new Value(13, "deniedtoomanycerts");
    public static final Value DENIED_REQUEST = new Value(14, "deniedrequest");

    public BATCAuthorizationValidationResponseCode(Value value) {
        super(value);
        this.addValueToList(OK);
        this.addValueToList(CANT_PRASE);
        this.addValueToList(BAD_CONTENTTYPE);
        this.addValueToList(IMONTTHERE_CIPIENT);
        this.addValueToList(UNKNOW_ENCRYPTION_ALGORITHM);
        this.addValueToList(DECRYPTION_FAILED);
        this.addValueToList(INVALID_AA);
        this.addValueToList(INVALID_AA_SIGNATURE);
        this.addValueToList(WRONGEA);
        this.addValueToList(UNKNOWN_ITS);
        this.addValueToList(INVALID_SIGNATURE);
        this.addValueToList(INVALID_ENCRYPTION_KEY);
        this.addValueToList(DENIED_PERMISSIONS);
        this.addValueToList(DENIED_TOO_MANY_CERTS);
        this.addValueToList(DENIED_REQUEST);
    }
    public static BATCAuthorizationValidationResponseCode getInstance(byte[] data) throws Exception {
        //获取选择位置
        BigInteger choice = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        //枚举值判断
        Value value = BATCResponseCodeEnum.AuthorizationValidationResponseCode.getValue(choice.intValue());
        BATCAuthorizationValidationResponseCode responseCode = new BATCAuthorizationValidationResponseCode(value);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        responseCode.setGoal(goal);
        return responseCode;
    }
}
