package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.BitByte;
import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.gbt.asn1.Certificate;
import org.bouncycastle.util.BigIntegers;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/***
 * CertResponse ::= SEQUENCE{
 * certificate				Certificate		--- PC证书
 * signPrivKeyReconstructionC	 OCTET STRING(SIZE(32))	--- PC证书对应的签名私钥重构值
 * encPrivKeyReconstructionC   OCTET STRING(SIZE(32))  Optional --- PC证书对应的加密私钥重构值
 * })
 */
public class BATCCertResponse extends Sequence {

    private Certificate certificate;
    private OctetString signPrivKeyReconstructionC;
    private OctetString encPrivKeyReconstructionC;

    public BATCCertResponse() {
        super(false, true);
    }

    public static BATCCertResponse getInstance(byte[] data) throws Exception {
        BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        List<Integer> integers = BitByte.setBit(integer.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        BATCCertResponse certResponse = new BATCCertResponse();
        //certificate
        Certificate certificate = Certificate.getInstance(data);
        data = certificate.getGoal();
        //signPrivKeyReconstructionC
        OctetString signPrivKeyReconstructionC = OctetString.getInstance(data, 32);
        data = signPrivKeyReconstructionC.getGoal();
        if (integers.contains(0)) {
            //encPrivKeyReconstructionC
            OctetString encPrivKeyReconstructionC = OctetString.getInstance(data, 32);
            data = encPrivKeyReconstructionC.getGoal();
            certResponse.setEncPrivKeyReconstructionC(encPrivKeyReconstructionC);
        }
        certResponse.setCertificate(certificate);
        certResponse.setSignPrivKeyReconstructionC(signPrivKeyReconstructionC);
        certResponse.setGoal(data);
        return certResponse;
    }

    public Certificate getCertificate() {
        return certificate;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public OctetString getSignPrivKeyReconstructionC() {
        return signPrivKeyReconstructionC;
    }

    public void setSignPrivKeyReconstructionC(OctetString signPrivKeyReconstructionC) {
        this.signPrivKeyReconstructionC = signPrivKeyReconstructionC;
    }

    public OctetString getEncPrivKeyReconstructionC() {
        return encPrivKeyReconstructionC;
    }

    public void setEncPrivKeyReconstructionC(OctetString encPrivKeyReconstructionC) {
        this.encPrivKeyReconstructionC = encPrivKeyReconstructionC;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        List<Integer> optionals = new ArrayList<>();
        if (this.encPrivKeyReconstructionC != null) {
            optionals.add(7);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(certificate);
        vector.add(signPrivKeyReconstructionC);
        vector.add(encPrivKeyReconstructionC);
        return vector;
    }
}
