package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.Choice;
import com.xdja.pki.oer.base.Null;
import com.xdja.pki.oer.base.OctetString;
import org.bouncycastle.util.BigIntegers;

import java.math.BigInteger;
import java.util.Vector;

/**
 * CertificateId ::= CHOICE {
 * linkageData LinkageData,
 * name Hostname,  --ec证书申请使用
 * binaryId OCTET STRING(SIZE(1..64)),
 * none NULL,    --pc证书申请使用
 * ...
 * }
 */
public class BATCCertificateId extends Choice {
    private BATCLinkageData linkageData;
    private BATCHostname name;
    private OctetString binaryId;
    private Null none;

    public static BATCCertificateId getInstance(byte[] data) throws Exception {
        BATCCertificateId certificateId = new BATCCertificateId();
        //choice
        BigInteger choice = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        switch (choice.intValue()) {
            case 0x80:
                //linkageData
                BATCLinkageData linkageData = BATCLinkageData.getInstance(data);
                certificateId.setLinkageData(linkageData);
                certificateId.setGoal(linkageData.getGoal());
                break;
            case 0x81:
                //name
                BATCHostname name = BATCHostname.getInstance(data);
                certificateId.setName(name);
                certificateId.setGoal(name.getGoal());
                break;
            case 0x82:
                //binaryId
                OctetString binaryId = OctetString.getInstance(data);
                certificateId.setBinaryId(binaryId);
                certificateId.setGoal(binaryId.getGoal());
                break;
            case 0x83:
                certificateId.setNone(new Null());
                certificateId.setGoal(data);
                break;
            default:
                throw new Exception("unknown choice value" + choice);
        }
        return certificateId;
    }

    public BATCLinkageData getLinkageData() {
        return linkageData;
    }

    public void setLinkageData(BATCLinkageData linkageData) {
        this.linkageData = linkageData;
    }

    public BATCHostname getName() {
        return name;
    }

    public void setName(BATCHostname name) {
        this.addIndex(1);
        this.name = name;
    }

    public OctetString getBinaryId() {
        return binaryId;
    }

    public void setBinaryId(OctetString binaryId) {
        this.addIndex(2);
        this.binaryId = binaryId;
    }

    public Null getNone() {
        return none;
    }

    public void setNone(Null none) {
        this.addIndex(3);
        this.none = none;
    }

    @Override
    public Vector getChoiceValues() {
        Vector vector = new Vector();
        vector.add(linkageData);
        vector.add(name);
        vector.add(binaryId);
        vector.add(none);
        return vector;
    }
}
