package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.BitByte;
import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.gbt.asn1.GeographicRegion;
import com.xdja.pki.oer.gbt.asn1.SequenceOfItsAidSspList;
import com.xdja.pki.oer.gbt.asn1.SubjectAssurance;
import com.xdja.pki.oer.gbt.asn1.ValidityPeriod;
import org.bouncycastle.util.BigIntegers;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/***
 * CertificateSubjectAttributes ::= SEQUENCE {
 * id BATCCertificateId OPTIONAL,
 * validityPeriod ValidityPeriod OPTIONAL,
 * region GeographicRegion OPTIONAL,
 * assuranceLevel SubjectAssurance OPTIONAL,
 * appPermissions SequenceOfItsAidSspList OPTIONAL,
 * certIssuePermissions SequenceOfItsAidSspList OPTIONAL,
 * ...
 * }(WITH COMPONENTS { ..., appPermissions PRESENT}
 */
public class BATCCertificateSubjectAttributes extends Sequence {
    private BATCCertificateId id;
    private ValidityPeriod validityPeriod;
    private GeographicRegion region;
    private SubjectAssurance assurance;
    private SequenceOfItsAidSspList appPermissions;
    private SequenceOfItsAidSspList certIssuePermissions;

    public BATCCertificateSubjectAttributes() {
        super(true, true);
    }

    public static BATCCertificateSubjectAttributes getInstance(byte[] data) throws Exception {
        BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        List<Integer> integers = BitByte.setBit(integer.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        BATCCertificateSubjectAttributes certificateSubjectAttributes = new BATCCertificateSubjectAttributes();
        if (integers.contains(0)) {
            //扩展
        }
        if (integers.contains(1)) {
            //id
            BATCCertificateId id = BATCCertificateId.getInstance(data);
            data = id.getGoal();
            certificateSubjectAttributes.setId(id);
        }
        if (integers.contains(2)) {
            //validityPeriod
            ValidityPeriod validityPeriod = ValidityPeriod.getInstance(data);
            data = validityPeriod.getGoal();
            certificateSubjectAttributes.setValidityPeriod(validityPeriod);
        }
        if (integers.contains(3)) {
            //region
            GeographicRegion region = GeographicRegion.getInstance(data);
            data = region.getGoal();
            certificateSubjectAttributes.setRegion(region);
        }
        if (integers.contains(4)) {
            //assurance
            SubjectAssurance assurance = SubjectAssurance.getInstance(data);
            data = assurance.getGoal();
            certificateSubjectAttributes.setAssurance(assurance);
        }
        if (integers.contains(5)) {
            //appPermissions
            SequenceOfItsAidSspList appPermissions = SequenceOfItsAidSspList.getInstance(data);
            data = appPermissions.getGoal();
            certificateSubjectAttributes.setAppPermissions(appPermissions);
        }
        if (integers.contains(6)) {
            //certIssuePermissions
            SequenceOfItsAidSspList certIssuePermissions = SequenceOfItsAidSspList.getInstance(data);
            data = certIssuePermissions.getGoal();
            certificateSubjectAttributes.setCertIssuePermissions(certIssuePermissions);
        }
        certificateSubjectAttributes.setGoal(data);
        return certificateSubjectAttributes;
    }

    public BATCCertificateId getId() {
        return id;
    }

    public void setId(BATCCertificateId id) {
        this.id = id;
    }

    public ValidityPeriod getValidityPeriod() {
        return validityPeriod;
    }

    public void setValidityPeriod(ValidityPeriod validityPeriod) {
        this.validityPeriod = validityPeriod;
    }

    public GeographicRegion getRegion() {
        return region;
    }

    public void setRegion(GeographicRegion region) {
        this.region = region;
    }

    public SubjectAssurance getAssurance() {
        return assurance;
    }

    public void setAssurance(SubjectAssurance assurance) {
        this.assurance = assurance;
    }

    public SequenceOfItsAidSspList getAppPermissions() {
        return appPermissions;
    }

    public void setAppPermissions(SequenceOfItsAidSspList appPermissions) {
        this.appPermissions = appPermissions;
    }

    public SequenceOfItsAidSspList getCertIssuePermissions() {
        return certIssuePermissions;
    }

    public void setCertIssuePermissions(SequenceOfItsAidSspList certIssuePermissions) {
        this.certIssuePermissions = certIssuePermissions;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        List<Integer> optionals = new ArrayList<>();
        if (this.id != null) {
            optionals.add(7);
        }
        if (this.validityPeriod != null) {
            optionals.add(6);
        }
        if (this.region != null) {
            optionals.add(5);
        }
        if (this.assurance != null) {
            optionals.add(4);
        }
        if (this.appPermissions != null) {
            optionals.add(3);
        }
        if (this.certIssuePermissions != null) {
            optionals.add(2);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(id);
        vector.add(validityPeriod);
        vector.add(region);
        vector.add(assurance);
        vector.add(appPermissions);
        vector.add(certIssuePermissions);
        return vector;
    }
}
