package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.gbt.asn1.SecuredMessage;

/**
 * EasVassServerTimeResponse ::= SecuredMessage(WITH COMPONENTS { ...,
 * 	version(2),
 * 	payload(WITH COMPONENTS { ...,
 * 		signedData(WITH COMPONENTS { ...,
 * 			signer(WITH COMPONENTS {
 * 				certificate(SequenceOfCertificate(SIZE(1))) --ECA证书
 *                        }),
 * 			tbs(WITH COMPONENTS { ...,
 * 				headerInfo(WITH COMPONENTS { ...,
 * 					itsAid(36),
 * 					hashAlg PRESENT,
 * 					genTime PRESENT,
 * 					expiryTime ABSENT,
 * 					digest ABSENT,
 * 					encKey ABSENT
 *                }),
 * 				data(CONTAINING ITSDataContent (WITH COMPONENTS { ...,
 * 					serverTime
 *                 }))
 *                 extHash  ABSENT
 *            })* 		})
 * 	})
 * })
 * @author wzs
 * @version v1.0
 * @ClassName BATCEasVassServerTimeResponse
 * @Date 2020/02/16 11:19
 */
public class BATCEasVassServerTimeResponse extends SecuredMessage {
    public static BATCEasVassServerTimeResponse getInstance(byte[] data) throws Exception {
        SecuredMessage instance = SecuredMessage.getInstance(data);
        BATCEasVassServerTimeResponse serverTimeResponse = new BATCEasVassServerTimeResponse();
        serverTimeResponse.setPayload(instance.getPayload());
        serverTimeResponse.setVersion(instance.getVersion());
        serverTimeResponse.setGoal(instance.getGoal());
        return serverTimeResponse;
    }
}
