package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.gbt.asn1.SecuredMessage;

/***
 * EcSignature::= SecuredMessage(WITH COMPONENTS { ...,
 * 	version(2),
 * 	payload(WITH COMPONENTS { ...,
 * 		encData(WITH COMPONENTS { ...,
 * 			recipients(SequenceOfRecipientInfo (SIZE(1)) (CONSTRAINED BY {
 * 				RecipientInfo(WITH COMPONENTS {
 * 					certRecipInfo	--使用ECA加密公钥进行加密
 *                                })* 			})),
 * cipherText	--支持 sm4Ecb、aesCc        种
 *            })
 *    })
 * })
 */
public class BATCEcSignature extends SecuredMessage {
    public static BATCEcSignature getInstance(SecuredMessage data) throws Exception {
     return getInstance(data.getEncode());
    }
    public static BATCEcSignature getInstance(byte[] data) throws Exception {
        SecuredMessage instance = SecuredMessage.getInstance(data);
        BATCEcSignature ecSignature = new BATCEcSignature();
        ecSignature.setPayload(instance.getPayload());
        ecSignature.setVersion(instance.getVersion());
        ecSignature.setGoal(instance.getGoal());
        return ecSignature;
    }
}
