package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.gbt.asn1.SecuredMessage;

/***
 * EnrollmentCertRequestDataSign::= SecuredMessage(WITH COMPONENTS { ...,
 * 	version(2),
 * 	payload(WITH COMPONENTS { ...,
 * 		signedData(WITH COMPONENTS { ...,
 * 			signer(WITH COMPONENTS {
 * 				certificate(SequenceOfCertificate(SIZE(1))) --旧的EC证书
 *                        }),
 * 			tbs(WITH COMPONENTS { ...,
 * 				headerInfo(WITH COMPONENTS { ...,
 * 					itsAid（623）,
 * 					hashAlg PRESENT,
 * 					genTime PRESENT,
 * 					expiryTime ABSENT,
 * 					digest ABSENT,
 * 					encKey  ABSENT
 *                }),
 *                 data(CONTAINING ITSDataContent (WITH COMPONENTS { ...,
 * 					enrolmentRequest --对应EC证书请求结构体，参见文件：vass-eas-ec-apply.asn
 *                 })),
 * 				extHash  ABSENT
 *            })*
 *         })
 *    })
 * })
 * @author wzs
 * @version v1.0
 * @ClassName BATCEnrollmentCertRequestDataSign
 * @Date 2020/02/16 11:19
 */
public class BATCEnrollmentCertRequestDataSign extends SecuredMessage {
    public static BATCEnrollmentCertRequestDataSign getInstance(byte[] data) throws Exception {
        SecuredMessage instance = SecuredMessage.getInstance(data);
        BATCEnrollmentCertRequestDataSign ecRequest = new BATCEnrollmentCertRequestDataSign();
        ecRequest.setPayload(instance.getPayload());
        ecRequest.setVersion(instance.getVersion());
        ecRequest.setGoal(instance.getGoal());
        return ecRequest;
    }
}
