package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.gbt.asn1.SecuredMessage;

/**
 *BATCEnrollmentCertResponseData::= SecuredMessage(WITH COMPONENTS { ...,
 * 	version(2),
 * 	payload(WITH COMPONENTS { ...,
 * 		signedData(WITH COMPONENTS { ...,
 * 			signer(WITH COMPONENTS {
 * 				certificate(SequenceOfCertificate(SIZE(1))) -- ECA证书
 *                        }),
 * 			tbs(WITH COMPONENTS { ...,
 * 				headerInfo(WITH COMPONENTS { ...,
 * 					itsAid（623）,
 * 					hashAlg PRESENT,
 * 					genTime PRESENT,
 * 					expiryTime ABSENT,
 * 					digest ABSENT,
 * 					encKey  ABSENT
 *                }),
 *                 data(CONTAINING ITSDataContent (WITH COMPONENTS { ...,
 * 					enrolmentResponse
 *                 })),
 * 				extHash  ABSENT
 *            })* 		})
 * 	})
 * })
 * @author wzs
 * @version v1.0
 * @ClassName BATCEnrollmentCertResponseData
 * @Date 2020/02/16 11:19
 */
public class BATCEnrollmentCertResponseData extends SecuredMessage {
    public static BATCEnrollmentCertResponseData getInstance(byte[] data) throws Exception {
        SecuredMessage instance = SecuredMessage.getInstance(data);
        BATCEnrollmentCertResponseData certResponseData = new BATCEnrollmentCertResponseData();
        certResponseData.setPayload(instance.getPayload());
        certResponseData.setVersion(instance.getVersion());
        certResponseData.setGoal(instance.getGoal());
        return certResponseData;
    }
}

