package com.xdja.pki.oer.batc;


import com.xdja.pki.oer.base.Enumerated;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;

/***
 * BATCEnrolmentResponseCode ::= ENUMERATED {
 * ok(0),
 * cantparse, -- valid for any structure
 * badcontenttype, -- not encrypted, not signed, not enrolmentrequest
 * imnottherecipient, -- the "recipients" doesn't include me
 * unknownencryptionalgorithm, -- either kexalg or contentencryptionalgorithm
 * decryptionfailed, -- works for ECIES-HMAC and AES-CCM
 * unknownits, -- can't retrieve the ITS from the itsId
 * invalidsignature, -- signature verification of the request fails
 * invalidencryptionkey, -- signature is good, but the responseEncryptionKey is bad
 * baditsstatus, -- revoked, not yet active
 * incompleterequest, -- some elements are missing
 * deniedpermissions, -- requested permissions are not granted
 * invalidkeys, -- either the verification_key of the encryption_key is bad
 * deniedrequest, -- any other reason?
 * ... }
 */
public class BATCEnrolmentResponseCode extends Enumerated {
    private static Logger logger = LoggerFactory.getLogger(BATCEnrolmentResponseCode.class);

    public static final Enumerated.Value OK = new Value(0, "ok");
    public static final Value CANT_PRASE = new Value(1, "cantparse");
    public static final Value BAD_CONTENTTYPE = new Value(2, "badcontenttype");
    public static final Value IMONTTHERE_CIPIENT = new Value(3, "imnottherecipient");
    public static final Value UNKNOW_ENCRYPTION_ALGORITHM = new Value(4, "unknownencryptionalgorithm");
    public static final Value DECRYPTION_FAILED = new Value(5, "decryptionfailed");
    public static final Value UNKNOWN_ITS = new Value(6, "unknownits");
    public static final Value INVALID_SIGNATURE = new Value(7, "invalidsignature");
    public static final Value INCALID_ENTCRYPTIONKEY = new Value(8, "invalidencryptionkey");
    public static final Value BAD_ITS_STATUS = new Value(9, "baditsstatus");
    public static final Value INCOMPLETE_REQUEST = new Value(10, "incompleterequest");
    public static final Value DENIED_PERMISSIONS = new Value(11, "deniedpermissions");
    public static final Value IN_VALIDKEYS = new Value(12, "invalidkeys");
    public static final Value DENIED_REQUEST = new Value(13, "deniedrequest");


    public BATCEnrolmentResponseCode(Value value) {
        super(value);
        this.addValueToList(OK);
        this.addValueToList(CANT_PRASE);
        this.addValueToList(BAD_CONTENTTYPE);
        this.addValueToList(IMONTTHERE_CIPIENT);
        this.addValueToList(UNKNOW_ENCRYPTION_ALGORITHM);
        this.addValueToList(DECRYPTION_FAILED);
        this.addValueToList(UNKNOWN_ITS);
        this.addValueToList(INVALID_SIGNATURE);
        this.addValueToList(INCALID_ENTCRYPTIONKEY);
        this.addValueToList(BAD_ITS_STATUS);
        this.addValueToList(INCOMPLETE_REQUEST);
        this.addValueToList(DENIED_PERMISSIONS);
        this.addValueToList(IN_VALIDKEYS);
        this.addValueToList(DENIED_REQUEST);
    }

    public static BATCEnrolmentResponseCode getInstance(byte[] data) throws Exception {
        //获取选择位置
        BigInteger choice = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        //枚举值判断
        Value value = BATCResponseCodeEnum.EnrolmentResponseCode.getValue(choice.intValue());
        BATCEnrolmentResponseCode responseCode = new BATCEnrolmentResponseCode(value);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        responseCode.setGoal(goal);
        return responseCode;
    }

}
