package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.base.Sequence;

import java.util.Vector;

/***
 * BATCGroupLinkageValue ::= SEQUENCE {
 * jValue OCTET STRING (SIZE(4)),
 * value OCTET STRING (SIZE(9))
 *  }
 */
public class BATCGroupLinkageValue extends Sequence {
    private OctetString jValue;
    private OctetString value;

    public BATCGroupLinkageValue() {
        super(false, false);
    }

    public static BATCGroupLinkageValue getInstance(byte[] data) throws Exception {
        //jValue
        OctetString jValue = OctetString.getInstance(data, 4);
        data = jValue.getGoal();
        //value
        OctetString value = OctetString.getInstance(data, 9);
        BATCGroupLinkageValue groupLinkageValue = new BATCGroupLinkageValue();
        groupLinkageValue.setjValue(jValue);
        groupLinkageValue.setValue(value);
        groupLinkageValue.setGoal(value.getGoal());
        return groupLinkageValue;
    }

    public OctetString getjValue() {
        return jValue;
    }

    public void setjValue(OctetString jValue) {
        this.jValue = jValue;
    }

    public OctetString getValue() {
        return value;
    }

    public void setValue(OctetString value) {
        this.value = value;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(jValue);
        vector.add(value);
        return vector;
    }
}
