package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.Choice;
import com.xdja.pki.oer.gbt.asn1.Time32;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.util.Vector;

/***
 * BATCITSDataContent ::= CHOICE {
 *     enrolmentRequest BATCInnerEcRequestSignedForPop,    ---EC证书申请
 *     enrolmentResponse BATCInnerEcResponse,              ---EC证书申请响应
 *     authorizationRequest BATCInnerAtRequest,            ---假名证书申请请求
 *     authorizationResponse BATCInnerAtResponse,          ---假名证书申请请求  响应
 *     authorizationValidationRequest BATCAuthorizationValidationRequest,  --- EC证书验证请求
 *     authorizationValidationResponse BATCAuthorizationValidationResponse, --- EC证书验证请求响应
 *     serverTime	Time32，                             ---服务器时间请求
 *     authorizationDownloadRequest  BATCInnerATDownloadRequest ，   ---假名证书下载请求
 *     authorizationDownloadResponse  BATCInnerATDownloadResponse ， ---假名证书下载响应
 *         ...
 * }
 */
public class BATCITSDataContent extends Choice {
    private static Logger logger = LoggerFactory.getLogger(BATCITSDataContent.class);

    private BATCInnerEcRequestSignedForPop enrolmentRequest;
    private BATCInnerEcResponse enrolmentResponse;
    private BATCInnerAtRequest authorizationRequest;
    private BATCInnerAtResponse authorizationResponse;
    private BATCAuthorizationValidationRequest authorizationValidationRequest;
    private BATCAuthorizationValidationResponse authorizationValidationResponse;
    private Time32 serverTime;
    private BATCInnerATDownloadRequest authorizationDownloadRequest;
    private BATCInnerATDownloadResponse authorizationDownloadResponse;

    public static BATCITSDataContent getInstance(byte[] data) throws Exception {
        //ByteArrayUtils.printHexBinary(logger, "BATCITSDataContent start data ", data);
        BATCITSDataContent itsDataContent = new BATCITSDataContent();
        BigInteger choice = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        switch (choice.intValue()) {
            case 0x80://enrolmentRequest
                BATCInnerEcRequestSignedForPop enrolmentRequest = BATCInnerEcRequestSignedForPop.getInstance(data);
                itsDataContent.setEnrolmentRequest(enrolmentRequest);
                data = enrolmentRequest.getGoal();
                break;
            case 0x81://enrolmentResponse
                BATCInnerEcResponse enrolmentResponse = BATCInnerEcResponse.getInstance(data);
                itsDataContent.setEnrolmentResponse(enrolmentResponse);
                data = enrolmentResponse.getGoal();
                break;
            case 0x82://authorizationRequest
                BATCInnerAtRequest authorizationRequest = BATCInnerAtRequest.getInstance(data);
                itsDataContent.setAuthorizationRequest(authorizationRequest);
                data = authorizationRequest.getGoal();
                break;
            case 0x83://authorizationResponse
                BATCInnerAtResponse authorizationResponse = BATCInnerAtResponse.getInstance(data);
                itsDataContent.setAuthorizationResponse(authorizationResponse);
                data = authorizationResponse.getGoal();
                break;
            case 0x84://authorizationValidationRequest
                BATCAuthorizationValidationRequest authorizationValidationRequest = BATCAuthorizationValidationRequest.getInstance(data);
                itsDataContent.setAuthorizationValidationRequest(authorizationValidationRequest);
                data = authorizationValidationRequest.getGoal();
                break;
            case 0x85://authorizationValidationResponse
                BATCAuthorizationValidationResponse authorizationValidationResponse = BATCAuthorizationValidationResponse.getInstance(data);
                itsDataContent.setAuthorizationValidationResponse(authorizationValidationResponse);
                data = authorizationValidationResponse.getGoal();
                break;
            case 0x86://serverTime
                Time32 serverTime = Time32.getInstance(data);
                itsDataContent.setServerTime(serverTime);
                data = serverTime.getGoal();
                break;
            case 0x87://authorizationDownloadRequest
                BATCInnerATDownloadRequest authorizationDownloadRequest = BATCInnerATDownloadRequest.getInstance(data);
                itsDataContent.setAuthorizationDownloadRequest(authorizationDownloadRequest);
                data = authorizationDownloadRequest.getGoal();
                break;
            case 0x88://authorizationDownloadResponse
                BATCInnerATDownloadResponse authorizationDownloadResponse = BATCInnerATDownloadResponse.getInstance(data);
                itsDataContent.setAuthorizationDownloadResponse(authorizationDownloadResponse);
                data = authorizationDownloadResponse.getGoal();
                break;
            default:
                throw new Exception("unknown the choice value: " + choice.intValue());
        }
        itsDataContent.setGoal(data);
        return itsDataContent;

    }

    public BATCInnerEcRequestSignedForPop getEnrolmentRequest() {
        return enrolmentRequest;
    }

    public void setEnrolmentRequest(BATCInnerEcRequestSignedForPop enrolmentRequest) {
        this.enrolmentRequest = enrolmentRequest;
    }

    public BATCInnerEcResponse getEnrolmentResponse() {
        return enrolmentResponse;
    }

    public void setEnrolmentResponse(BATCInnerEcResponse enrolmentResponse) {
        this.addIndex(1);
        this.enrolmentResponse = enrolmentResponse;
    }

    public BATCInnerAtRequest getAuthorizationRequest() {
        return authorizationRequest;
    }

    public void setAuthorizationRequest(BATCInnerAtRequest authorizationRequest) {
        this.addIndex(2);
        this.authorizationRequest = authorizationRequest;
    }

    public BATCInnerAtResponse getAuthorizationResponse() {
        return authorizationResponse;
    }

    public void setAuthorizationResponse(BATCInnerAtResponse authorizationResponse) {
        this.addIndex(3);
        this.authorizationResponse = authorizationResponse;
    }

    public BATCAuthorizationValidationRequest getAuthorizationValidationRequest() {
        return authorizationValidationRequest;
    }

    public void setAuthorizationValidationRequest(BATCAuthorizationValidationRequest authorizationValidationRequest) {
        this.addIndex(4);
        this.authorizationValidationRequest = authorizationValidationRequest;
    }

    public BATCAuthorizationValidationResponse getAuthorizationValidationResponse() {
        return authorizationValidationResponse;
    }

    public void setAuthorizationValidationResponse(BATCAuthorizationValidationResponse authorizationValidationResponse) {
        this.addIndex(5);
        this.authorizationValidationResponse = authorizationValidationResponse;
    }

    public Time32 getServerTime() {
        return serverTime;
    }

    public void setServerTime(Time32 serverTime) {
        this.addIndex(6);
        this.serverTime = serverTime;
    }

    public BATCInnerATDownloadRequest getAuthorizationDownloadRequest() {
        return authorizationDownloadRequest;
    }

    public void setAuthorizationDownloadRequest(BATCInnerATDownloadRequest authorizationDownloadRequest) {
        this.addIndex(7);
        this.authorizationDownloadRequest = authorizationDownloadRequest;
    }

    public BATCInnerATDownloadResponse getAuthorizationDownloadResponse() {
        return authorizationDownloadResponse;
    }

    public void setAuthorizationDownloadResponse(BATCInnerATDownloadResponse authorizationDownloadResponse) {
        this.addIndex(8);
        this.authorizationDownloadResponse = authorizationDownloadResponse;
    }

    @Override
    public Vector getChoiceValues() {
        Vector vector = new Vector();
        vector.add(enrolmentRequest);
        vector.add(enrolmentResponse);
        vector.add(authorizationRequest);
        vector.add(authorizationResponse);
        vector.add(authorizationValidationRequest);
        vector.add(authorizationValidationResponse);
        vector.add(serverTime);
        vector.add(authorizationDownloadRequest);
        vector.add(authorizationDownloadResponse);
        return vector;
    }
}
