package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.gbt.asn1.Time32;

import java.util.Vector;

/***
 * InnerATDownloadRequest ::= SEQUENCE {
 *     timeStamp         Time32,                       --- PCA返回的下载时间
 *     requestHash       OCTET STRING(SIZE(16))  --- 对应的假名证书请求的hash后16位
 * }
 */
public class BATCInnerATDownloadRequest extends Sequence {
    private Time32 timeStamp;
    private OctetString requestHash;

    public BATCInnerATDownloadRequest() {
        super(false, false);
    }

    public static BATCInnerATDownloadRequest getInstance(byte[] data) throws Exception{
        //timeStamp
        Time32 timeStamp = Time32.getInstance(data);
        data = timeStamp.getGoal();
        //requestHash
        OctetString requestHash = OctetString.getInstance(data, 16);
        BATCInnerATDownloadRequest request = new BATCInnerATDownloadRequest();
        request.setTimeStamp(timeStamp);
        request.setRequestHash(requestHash);
        request.setGoal(requestHash.getGoal());
        return request;
    }

    public Time32 getTimeStamp() {
        return timeStamp;
    }

    public void setTimeStamp(Time32 timeStamp) {
        this.timeStamp = timeStamp;
    }

    public OctetString getRequestHash() {
        return requestHash;
    }

    public void setRequestHash(OctetString requestHash) {
        this.requestHash = requestHash;
    }

    @Override
    public Vector getSequenceValues() {
       Vector vector = new Vector();
       vector.add(timeStamp);
       vector.add(requestHash);
       return vector;
    }
}
