package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.BitByte;
import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.gbt.asn1.Time32;
import org.bouncycastle.util.BigIntegers;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/***
 * InnerATDownloadResponse ::= SEQUENCE {
 * requestHash    OCTET STRING(SIZE(16)) ---取请求结构体hash的后16位
 * responseCode  AuthorizationResponseCode
 * certDLTime		Time32    OPTIONAL --- 下载时间
 * certDLURL		OCTET STRING(SIZE(0...MAX))  OPTIONAL --- 下载地址
 * }(WITH COMPONENTS { responseCode (ok), certDLTime certDLURL  PRESENT }
 * | WITH COMPONENTS { responseCode (ALL EXCEPT ok), certDLTime certDLUR ABSENT }
 * )
 */
public class BATCInnerATDownloadResponse extends Sequence {
    private OctetString requestHash;
    private BATCAuthorizationResponseCode responseCode;
    private Time32 certDLTime;
    private OctetString certDLURL;

    public BATCInnerATDownloadResponse() {
        super(false, true);
    }

    public static BATCInnerATDownloadResponse getInstance(byte[] data) throws Exception {
        BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        List<Integer> integers = BitByte.setBit(integer.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        BATCInnerATDownloadResponse response = new BATCInnerATDownloadResponse();
        //requestHash
        OctetString requestHash = OctetString.getInstance(data, 16);
        data = requestHash.getGoal();
        //responseCode
        BATCAuthorizationResponseCode responseCode = BATCAuthorizationResponseCode.getInstance(data);
        data = responseCode.getGoal();
        //certDLTime
        if (integers.contains(0)){
            Time32 certDLTime = Time32.getInstance(data);
            response.setCertDLTime(certDLTime);
            data = certDLTime.getGoal();
        }
        if (integers.contains(1)){
            OctetString certDLURL = OctetString.getInstance(data);
            response.setCertDLURL(certDLURL);
            data = certDLURL.getGoal();
        }
        response.setRequestHash(requestHash);
        response.setResponseCode(responseCode);
        response.setGoal(data);
        return response;
    }

    public OctetString getRequestHash() {
        return requestHash;
    }

    public void setRequestHash(OctetString requestHash) {
        this.requestHash = requestHash;
    }

    public BATCAuthorizationResponseCode getResponseCode() {
        return responseCode;
    }

    public void setResponseCode(BATCAuthorizationResponseCode responseCode) {
        this.responseCode = responseCode;
    }

    public Time32 getCertDLTime() {
        return certDLTime;
    }

    public void setCertDLTime(Time32 certDLTime) {
        this.certDLTime = certDLTime;
    }

    public OctetString getCertDLURL() {
        return certDLURL;
    }

    public void setCertDLURL(OctetString certDLURL) {
        this.certDLURL = certDLURL;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        List<Integer> optionals = new ArrayList<>();
        if (this.certDLTime != null) {
            optionals.add(7);
        }
        if (this.certDLURL != null){
            optionals.add(6);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(requestHash);
        vector.add(responseCode);
        vector.add(certDLTime);
        vector.add(certDLURL);
        return vector;
    }
}
