package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.gbt.asn1.HashAlgorithm;

import java.util.Vector;

/***
 * InnerATRequest::= SEQUENCE{
 * publicKeys			PublicKeys			----包含扩展签名和扩展加密公钥的结构体，需要参与最终证书中存放的衍生密钥的运算
 * hmacKey 			OCTET STRING (SIZE(32)),   --- 参与公钥mac运算所需的Key
 * hashAlg 			HashAlgorithm	--- hash算法  计算keyTag的hash算法
 * sharedAtRequest		SharedAtRequest	--- 包含证书构建的部分信息。
 * ecSignature			EcSignature
 * })
 */
public class BATCInnerAtRequest extends Sequence {
    private BATCPublicKeys publicKeys;
    private OctetString hmacKey;
    private HashAlgorithm hashAlg;
    private BATCSharedAtRequest sharedAtRequest;
    private BATCEcSignature ecSignature;


    public BATCInnerAtRequest() {
        super(false, false);
    }

    public static BATCInnerAtRequest getInstance(byte[] data) throws Exception {
        //public keys
        BATCPublicKeys publicKeys = BATCPublicKeys.getInstance(data);
        data = publicKeys.getGoal();
        //hmacKey
        OctetString hmacKey = OctetString.getInstance(data, 32);
        data = hmacKey.getGoal();
        //hashAlg
        HashAlgorithm hashAlgorithm = HashAlgorithm.getInstance(data);
        data = hashAlgorithm.getGoal();
        //shartAtRequest
        BATCSharedAtRequest sharedAtRequest = BATCSharedAtRequest.getInstance(data);
        data = sharedAtRequest.getGoal();
        //ecSignature
        BATCEcSignature ecSignature = BATCEcSignature.getInstance(data);
        data = ecSignature.getGoal();
        BATCInnerAtRequest request = new BATCInnerAtRequest();
        request.setPublicKeys(publicKeys);
        request.setHmacKey(hmacKey);
        request.setHashAlg(hashAlgorithm);
        request.setSharedAtRequest(sharedAtRequest);
        request.setEcSignature(ecSignature);
        request.setGoal(data);
        return request;
    }

    public BATCPublicKeys getPublicKeys() {
        return publicKeys;
    }

    public void setPublicKeys(BATCPublicKeys publicKeys) {
        this.publicKeys = publicKeys;
    }

    public OctetString getHmacKey() {
        return hmacKey;
    }

    public void setHmacKey(OctetString hmacKey) {
        this.hmacKey = hmacKey;
    }

    public HashAlgorithm getHashAlg() {
        return hashAlg;
    }

    public void setHashAlg(HashAlgorithm hashAlg) {
        this.hashAlg = hashAlg;
    }

    public BATCSharedAtRequest getSharedAtRequest() {
        return sharedAtRequest;
    }

    public void setSharedAtRequest(BATCSharedAtRequest sharedAtRequest) {
        this.sharedAtRequest = sharedAtRequest;
    }

    public BATCEcSignature getEcSignature() {
        return ecSignature;
    }

    public void setEcSignature(BATCEcSignature ecSignature) {
        this.ecSignature = ecSignature;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(publicKeys);
        vector.add(hmacKey);
        vector.add(hashAlg);
        vector.add(sharedAtRequest);
        vector.add(ecSignature);
        return vector;
    }
}
