package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.BitByte;
import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.base.Sequence;
import org.bouncycastle.util.BigIntegers;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/***
 * InnerATResponse ::= SEQUENCE {
 * requestHash OCTET STRING (SIZE(16)), ---取hash的后16位
 * responseCode AuthorizationResponseCode,
 * certResponse CertResponse OPTIONAL,
 * ...
 * } (WITH COMPONENTS { responseCode (ok), certificate PRESENT }
 * | WITH COMPONENTS { responseCode (ALL EXCEPT ok), certResponse ABSENT }
 * )
 */
public class BATCInnerAtResponse extends Sequence {
    private OctetString requestHash;
    private BATCAuthorizationResponseCode responseCode;
    private BATCCertResponse certResponse;

    public BATCInnerAtResponse() {
        super(true, true);
    }

    public static BATCInnerAtResponse getInstance(byte[] data) throws Exception {
        BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        List<Integer> integers = BitByte.setBit(integer.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        BATCInnerAtResponse innerAtResponse = new BATCInnerAtResponse();
        //requestHash
        OctetString requestHash = OctetString.getInstance(data, 16);
        data = requestHash.getGoal();
        //code
        BATCAuthorizationResponseCode responseCode = BATCAuthorizationResponseCode.getInstance(data);
        data = responseCode.getGoal();
        if (integers.contains(0)){
            //可以扩展
        }
        if (integers.contains(1)){
            BATCCertResponse certResponse = BATCCertResponse.getInstance(data);
            data = certResponse.getGoal();
            innerAtResponse.setCertResponse(certResponse);
        }
        innerAtResponse.setRequestHash(requestHash);
        innerAtResponse.setResponseCode(responseCode);
        innerAtResponse.setGoal(data);
        return innerAtResponse;
    }

    public OctetString getRequestHash() {
        return requestHash;
    }

    public void setRequestHash(OctetString requestHash) {
        this.requestHash = requestHash;
    }

    public BATCAuthorizationResponseCode getResponseCode() {
        return responseCode;
    }

    public void setResponseCode(BATCAuthorizationResponseCode responseCode) {
        this.responseCode = responseCode;
    }

    public BATCCertResponse getCertResponse() {
        return certResponse;
    }

    public void setCertResponse(BATCCertResponse certResponse) {
        this.certResponse = certResponse;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        List<Integer> optionals = new ArrayList<>();
        if (this.certResponse != null) {
            optionals.add(7);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(requestHash);
        vector.add(responseCode);
        vector.add(certResponse);
        return vector;
    }
}
