package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.BitByte;
import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.base.Sequence;
import org.bouncycastle.util.BigIntegers;

import java.math.BigInteger;
import java.util.List;
import java.util.Vector;

/**
 * InnerEcRequest ::= SEQUENCE {
 * itsId  OCTET STRING (SIZE(1...MAX)),  --LTC证书的DN项（DN中的CN项为 IMEI值的hash，当前可以取到的只有车辆的IMEI值，后续可根据实际设备情况额外增加）
 * certificateFormat CertificateFormat,  --证书格式版本 默认为2（integer）
 * publicKeys PublicKeys, -- 公钥信息
 * requestedSubjectAttributes CertificateSubjectAttributes,
 * ...
 * }
 *
 * @author wzs
 * @version v1.0
 * @ClassName InnerEcRequest
 * @Date 2020/02/14 11:19
 */
public class BATCInnerEcRequest extends Sequence {
    private OctetString itsId;
    private BATCCertificateFormat certificateFormat;
    private BATCPublicKeys publicKeys;
    private BATCCertificateSubjectAttributes requestedSubjectAttributes;

    public static BATCInnerEcRequest getInstance(byte[] data) throws Exception {
        BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        List<Integer> integers = BitByte.setBit(integer.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        BATCInnerEcRequest innerEcRequest = new BATCInnerEcRequest();
        OctetString itsId = OctetString.getInstance(data);
        data = itsId.getGoal();
        BATCCertificateFormat certificateFormat = BATCCertificateFormat.getInstance(data);
        data = certificateFormat.getGoal();
        BATCPublicKeys publicKeys = BATCPublicKeys.getInstance(data);
        data = publicKeys.getGoal();
        BATCCertificateSubjectAttributes requestedSubjectAttributes = BATCCertificateSubjectAttributes.getInstance(data);
        data = requestedSubjectAttributes.getGoal();
        innerEcRequest.setItsId(itsId);
        innerEcRequest.setCertificateFormat(certificateFormat);
        innerEcRequest.setPublicKeys(publicKeys);
        innerEcRequest.setRequestedSubjectAttributes(requestedSubjectAttributes);
        innerEcRequest.setGoal(data);
        return innerEcRequest;
    }

    public BATCInnerEcRequest() {
        super(true, false);
    }

    public OctetString getItsId() {
        return itsId;
    }

    public void setItsId(OctetString itsId) {
        this.itsId = itsId;
    }

    public BATCCertificateFormat getCertificateFormat() {
        return certificateFormat;
    }

    public void setCertificateFormat(BATCCertificateFormat certificateFormat) {
        this.certificateFormat = certificateFormat;
    }

    public BATCPublicKeys getPublicKeys() {
        return publicKeys;
    }

    public void setPublicKeys(BATCPublicKeys publicKeys) {
        this.publicKeys = publicKeys;
    }

    public BATCCertificateSubjectAttributes getRequestedSubjectAttributes() {
        return requestedSubjectAttributes;
    }

    public void setRequestedSubjectAttributes(BATCCertificateSubjectAttributes requestedSubjectAttributes) {
        this.requestedSubjectAttributes = requestedSubjectAttributes;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(itsId);
        vector.add(certificateFormat);
        vector.add(publicKeys);
        vector.add(requestedSubjectAttributes);
        return vector;
    }
}
