package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.gbt.asn1.SecuredMessage;

/***
 * BATCInnerEcRequestSignedForPop ::= SecuredMessage(WITH COMPONENTS { ...,
 * 	version(2),
 * 	payload(WITH COMPONENTS { ...,
 * 		signedData(WITH COMPONENTS { ...,
 * 			signer(WITH COMPONENTS {
 * 				self
 *                        }),
 * 			tbs(WITH COMPONENTS { ...,
 * 				headerInfo(WITH COMPONENTS { ...,
 * 					itsAid（623）,
 * 					hashAlg PRESENT,
 * 					genTime PRESENT,
 * 					expiryTime ABSENT,
 * 					digest ABSENT,
 * 					encKey ABSENT
 *                }),
 * data(CONTAINING InnerEcRequest)
 * 				extHash  ABSENT
 *            })* 		})
 * 	})
 * })
 * @author wzs
 * @version v1.0
 * @ClassName BATCInnerEcRequestSignedForPop
 * @Date 2020/02/16 11:19
 */
public class BATCInnerEcRequestSignedForPop extends SecuredMessage {
    public static BATCInnerEcRequestSignedForPop getInstance(byte[] data) throws Exception {
        SecuredMessage instance = SecuredMessage.getInstance(data);
        BATCInnerEcRequestSignedForPop ecRequest = new BATCInnerEcRequestSignedForPop();
        ecRequest.setPayload(instance.getPayload());
        ecRequest.setVersion(instance.getVersion());
        ecRequest.setGoal(instance.getGoal());
        return ecRequest;
    }
}
