package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.BitByte;
import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.gbt.asn1.Certificate;
import org.bouncycastle.util.BigIntegers;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/***
 *BATCInnerEcResponse ::= SEQUENCE {
 * requestHash OCTET STRING (SIZE(16)), 取hash的后16字节
 * responseCode BATCEnrolmentResponseCode,
 * ecCert Certificate OPTIONAL,
 * ...
 * } (WITH COMPONENTS { responseCode (ok), certificate PRESENT }
 * | WITH COMPONENTS { responseCode (ALL EXCEPT ok), certificate ABSENT }
 * )
 */
public class BATCInnerEcResponse extends Sequence {
    private OctetString requestHash;
    private BATCEnrolmentResponseCode responseCode;
    private Certificate ecCert;

    public BATCInnerEcResponse() {
        super(true, true);
    }

    public static BATCInnerEcResponse getInstance(byte[] data) throws Exception {
        BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        List<Integer> integers = BitByte.setBit(integer.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        BATCInnerEcResponse innerEcResponse = new BATCInnerEcResponse();
        //requestHash
        OctetString requestHash = OctetString.getInstance(data, 16);
        data = requestHash.getGoal();
        //code
        BATCEnrolmentResponseCode responseCode = BATCEnrolmentResponseCode.getInstance(data);
        data = responseCode.getGoal();
        if (integers.contains(0)){
            //可以扩展
        }
        if (integers.contains(1)){
            Certificate ecCert = Certificate.getInstance(data);
            data = ecCert.getGoal();
            innerEcResponse.setEcCert(ecCert);
        }
        innerEcResponse.setRequestHash(requestHash);
        innerEcResponse.setResponseCode(responseCode);
        innerEcResponse.setGoal(data);
        return innerEcResponse;
    }

    public OctetString getRequestHash() {
        return requestHash;
    }

    public void setRequestHash(OctetString requestHash) {
        this.requestHash = requestHash;
    }

    public BATCEnrolmentResponseCode getResponseCode() {
        return responseCode;
    }

    public void setResponseCode(BATCEnrolmentResponseCode responseCode) {
        this.responseCode = responseCode;
    }

    public Certificate getEcCert() {
        return ecCert;
    }

    public void setEcCert(Certificate ecCert) {
        this.ecCert = ecCert;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        List<Integer> optionals = new ArrayList<>();
        if (this.ecCert != null) {
            optionals.add(7);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(requestHash);
        vector.add(responseCode);
        vector.add(ecCert);
        return vector;
    }
}
