package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.base.Uint16;

import java.util.Vector;

/***
 * LinkageData ::= SEQUENCE {
 *  iCert  Uint16	--- i值,
 *  linkage-value LinkageValue,
 *  group-linkage-value BATCGroupLinkageValue OPTIONAL
 *  }
 */
public class BATCLinkageData extends Sequence {
    private Uint16 iCert;
    private BATCLinkageValue linkageValue;
    private BATCGroupLinkageValue groupLinkageValue;

    public BATCLinkageData() {
        super(false, true);
    }

    public static BATCLinkageData getInstance(byte[] data) throws Exception {
        BATCLinkageData batcLinkageData = new BATCLinkageData();
        //iCert
        Uint16 iCert = Uint16.getInstance(data);
        data = iCert.getGoal();
        //linkageValue
        BATCLinkageValue linkageValue = BATCLinkageValue.getInstance(data);
        data = linkageValue.getGoal();
        //groupLinkageValue
        BATCGroupLinkageValue groupLinkageValue = BATCGroupLinkageValue.getInstance(data);
        batcLinkageData.setiCert(iCert);
        batcLinkageData.setLinkageValue(linkageValue);
        batcLinkageData.setGroupLinkageValue(groupLinkageValue);
        batcLinkageData.setGoal(groupLinkageValue.getGoal());
        return batcLinkageData;
    }

    public Uint16 getiCert() {
        return iCert;
    }

    public void setiCert(Uint16 iCert) {
        this.iCert = iCert;
    }

    public BATCLinkageValue getLinkageValue() {
        return linkageValue;
    }

    public void setLinkageValue(BATCLinkageValue linkageValue) {
        this.linkageValue = linkageValue;
    }

    public BATCGroupLinkageValue getGroupLinkageValue() {
        return groupLinkageValue;
    }

    public void setGroupLinkageValue(BATCGroupLinkageValue groupLinkageValue) {
        this.groupLinkageValue = groupLinkageValue;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(iCert);
        vector.add(linkageValue);
        vector.add(groupLinkageValue);
        return vector;
    }
}
