package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.BitByte;
import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.gbt.asn1.PublicEncryptionKey;
import com.xdja.pki.oer.gbt.asn1.PublicVerifyKey;
import org.bouncycastle.util.BigIntegers;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/***
 * PublicKeys ::= SEQUENCE{
 * verificationKey PublicVerificationKey,
 * encryptionKey PublicEncryptionKey OPTIONAL
 * }
 */
public class BATCPublicKeys extends Sequence {
    private PublicVerifyKey verifyKey;
    private PublicEncryptionKey encryptionKey;

    public BATCPublicKeys() {
        super(false, true);
    }

    public static BATCPublicKeys getInstance(byte[] data) throws Exception{
        BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        List<Integer> integers = BitByte.setBit(integer.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        BATCPublicKeys publicKeys = new BATCPublicKeys();
        //verifyKey
        PublicVerifyKey verifyKey = PublicVerifyKey.getInstance(data);
        data = verifyKey.getGoal();
        //encryptKey
        if (integers.contains(0)){
            PublicEncryptionKey encryptionKey = PublicEncryptionKey.getInstance(data);
            publicKeys.setEncryptionKey(encryptionKey);
            data = encryptionKey.getGoal();
        }
        publicKeys.setVerifyKey(verifyKey);
        publicKeys.setGoal(data);
        return publicKeys;
    }

    public PublicVerifyKey getVerifyKey() {
        return verifyKey;
    }

    public void setVerifyKey(PublicVerifyKey verifyKey) {
        this.verifyKey = verifyKey;
    }

    public PublicEncryptionKey getEncryptionKey() {
        return encryptionKey;
    }

    public void setEncryptionKey(PublicEncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        List<Integer> optionals = new ArrayList<>();
        if (this.encryptionKey != null) {
            optionals.add(7);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(verifyKey);
        vector.add(encryptionKey);
        return vector;
    }
}
