package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.BitByte;
import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.gbt.asn1.HashedId8;
import org.bouncycastle.util.BigIntegers;

import java.math.BigInteger;
import java.util.List;
import java.util.Vector;

/**
 * SharedAtRequest ::= SEQUENCE{
 * eaId  			 HashedId8,    ---ECA证书hashid8
 * keyTag			OCTET STRING (SIZE(16))  --- 使用hmacKey和publicKeys计算出的keyTag;
 * certificateFormat	 CertificateFormat,   -- 证书格式版本 默认为2（integer）
 * requestedSubjecAttributes   CertificateSubjectAttributes
 * ...
 * }
 */
public class BATCSharedAtRequest extends Sequence {
    private HashedId8 eaId;
    private OctetString keyTag;
    private BATCCertificateFormat certificateFormat;
    private BATCCertificateSubjectAttributes requestedSubjectAttributes;

    public BATCSharedAtRequest() {
        super(true, false);
    }

    public static BATCSharedAtRequest getInstance(byte[] data) throws Exception {
        BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        List<Integer> integers = BitByte.setBit(integer.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        if (integers.contains(0)){
            //可扩展
        }
        BATCSharedAtRequest sharedAtRequest = new BATCSharedAtRequest();
        //eaId
        HashedId8 eaId = HashedId8.getInstance(data);
        data = eaId.getGoal();
        //keyTag
        OctetString keyTag = OctetString.getInstance(data, 16);
        data = keyTag.getGoal();
        //certificateFormat
        BATCCertificateFormat batcCertificateFormat = BATCCertificateFormat.getInstance(data);
        data = batcCertificateFormat.getGoal();
        //requestedSubjecAttributes
        BATCCertificateSubjectAttributes requestedSubjectAttributes = BATCCertificateSubjectAttributes.getInstance(data);
        data = requestedSubjectAttributes.getGoal();
        sharedAtRequest.setEaId(eaId);
        sharedAtRequest.setKeyTag(keyTag);
        sharedAtRequest.setCertificateFormat(batcCertificateFormat);
        sharedAtRequest.setRequestedSubjectAttributes(requestedSubjectAttributes);
        sharedAtRequest.setGoal(data);
        return sharedAtRequest;
    }

    public HashedId8 getEaId() {
        return eaId;
    }

    public void setEaId(HashedId8 eaId) {
        this.eaId = eaId;
    }

    public OctetString getKeyTag() {
        return keyTag;
    }

    public void setKeyTag(OctetString keyTag) {
        this.keyTag = keyTag;
    }

    public BATCCertificateFormat getCertificateFormat() {
        return certificateFormat;
    }

    public void setCertificateFormat(BATCCertificateFormat certificateFormat) {
        this.certificateFormat = certificateFormat;
    }

    public BATCCertificateSubjectAttributes getRequestedSubjectAttributes() {
        return requestedSubjectAttributes;
    }

    public void setRequestedSubjectAttributes(BATCCertificateSubjectAttributes requestedSubjectAttributes) {
        this.requestedSubjectAttributes = requestedSubjectAttributes;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(eaId);
        vector.add(keyTag);
        vector.add(certificateFormat);
        vector.add(requestedSubjectAttributes);
        return vector;
    }
}
