package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.base.Uint16;

import java.util.Vector;

/***
 * TbsRequest::= SEQUENCE {
 *     i					Unit16	--- i值    计算当前证书的生效时间和失效时间
 *     sharedAtRequestHash	 OCTET STRING(SIZE(32))	--- sharedAtRequest的hash值。 32个字节 ！！！
 * })
 */
public class BATCTbsRequest extends Sequence {

    private Uint16 i;
    private OctetString sharedAtRequestHash;

    public BATCTbsRequest() {
        super(false, false);
    }

    public static BATCTbsRequest getInstance(byte[] data) throws Exception {
        BATCTbsRequest tbsRequest = new BATCTbsRequest();
        //i
        Uint16 i = Uint16.getInstance(data);
        data = i.getGoal();
        //sharedAtRequestHash
        OctetString sharedAtRequestHash = OctetString.getInstance(data, 32);
        tbsRequest.setI(i);
        tbsRequest.setSharedAtRequestHash(sharedAtRequestHash);
        tbsRequest.setGoal(sharedAtRequestHash.getGoal());
        return tbsRequest;
    }

    public Uint16 getI() {
        return i;
    }

    public void setI(Uint16 i) {
        this.i = i;
    }

    public OctetString getSharedAtRequestHash() {
        return sharedAtRequestHash;
    }

    public void setSharedAtRequestHash(OctetString sharedAtRequestHash) {
        this.sharedAtRequestHash = sharedAtRequestHash;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(i);
        vector.add(sharedAtRequestHash);
        return vector;
    }
}
