package com.xdja.pki.oer.batc.builder;

import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA256DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.batc.*;
import com.xdja.pki.oer.core.TimeUtils;
import com.xdja.pki.oer.gbt.asn1.*;
import com.xdja.pki.oer.gbt.asn1.data.SecuredMessageBuilder;
import com.xdja.pki.oer.gbt.asn1.utils.EccPointBuilder;
import com.xdja.pki.oer.gbt.asn1.utils.SecureMessageUtils;
import com.xdja.pki.oer.gbt.asn1.utils.enums.EccCurveTypeEnum;
import com.xdja.pki.oer.gbt.asn1.utils.enums.EccPointTypeEnum;

import java.security.PrivateKey;
import java.security.PublicKey;

public class BATCECApplyBuilder {
    /**
     * 构建EC申请请求结构体
     *
     * @param privateKeyIndex
     * @param privateKeyPassword
     * @param imei
     * @param hostName
     * @return
     * @throws Exception
     */
    public static BATCITSDataContent buildECApplyRequest(int privateKeyIndex, String privateKeyPassword, String imei, String hostName) throws Exception {
        byte[] imeiHash = GMSSLSM3DigestUtils.digestByBC(imei.getBytes());
        BATCITSDataContent batcitsDataContent = new BATCITSDataContent();
        OctetString itsId = new OctetString();//构建itsId
        itsId.setString(imeiHash);
        BATCCertificateFormat certificateFormat = new BATCCertificateFormat((byte) 2);//构建certificateFormat
        BATCInnerEcRequest batcInnerEcRequest = new BATCInnerEcRequest();
        BATCPublicKeys batcPublicKeys = new BATCPublicKeys();
        //构建PublicVerifyKey
        PublicKey publicKey = GMSSLSM2KeyUtils.getEncryptPublicKeyByYunhsm(privateKeyIndex);
        PublicVerifyKey verifyKey = new PublicVerifyKey();
        verifyKey.setEccPoint(EccPointBuilder.build(publicKey, EccPointTypeEnum.UNCOMPRESSED));
        verifyKey.setEccCurve(new EccCurve(EccCurve.SGD_SM2));
        batcPublicKeys.setVerifyKey(verifyKey);
        //构建publicEncryptionKey
        PublicEncryptionKey publicEncryptionKey = new PublicEncryptionKey();
        publicEncryptionKey.setSupportedSymmAlg(new SymmetricAlgorithm(SymmetricAlgorithm.SGD_SM4_ECB));
        publicEncryptionKey.setEccCurve(new EccCurve(EccCurve.SGD_SM2));
        publicEncryptionKey.setPublicKey(EccPointBuilder.build(publicKey, EccPointTypeEnum.COMPRESSED_Y));
        batcPublicKeys.setEncryptionKey(publicEncryptionKey);
        BATCCertificateSubjectAttributes subjectAttributes = new BATCCertificateSubjectAttributes();
        BATCCertificateId batcCertificateId = new BATCCertificateId();
        BATCHostname batcHostname = new BATCHostname();
        batcHostname.setString(hostName.getBytes());
        batcCertificateId.setName(batcHostname);
        subjectAttributes.setId(batcCertificateId);
        ValidityPeriod validityPeriod = new ValidityPeriod();
        TimeStartAndEnd timeStartAndEnd = new TimeStartAndEnd();
        timeStartAndEnd.setStartValidity(new Time32(TimeUtils.getNowTime()));
        timeStartAndEnd.setEndValidity(new Time32(TimeUtils.getTimeAfterYear(1)));
        validityPeriod.setTimeStartAndEnd(timeStartAndEnd);
        subjectAttributes.setValidityPeriod(validityPeriod);
        GeographicRegion geographicRegion = new GeographicRegion();
        SequenceOfRectangularRegion regions = new SequenceOfRectangularRegion();
        RectangularRegion region = new RectangularRegion();
        TwoDLocation twoDLocation = new TwoDLocation();
        twoDLocation.setLongitude(new Longitude(123));
        twoDLocation.setLatitude(new Latitude(465));
        region.setNorthWest(twoDLocation);
        region.setSouthEast(twoDLocation);
        regions.addRectangularRegion(region);
        regions.addRectangularRegion(region);
        regions.addRectangularRegion(region);
        regions.addRectangularRegion(region);
        regions.addRectangularRegion(region);
        geographicRegion.setRectangularRegion(regions);
        subjectAttributes.setRegion(geographicRegion);
        SequenceOfItsAidSspList itsAidSspList = new SequenceOfItsAidSspList();
        ItsAidSsp itsAidSsp = new ItsAidSsp();
        itsAidSsp.setItsAid(ItsAid.TRAFFIC_LIGHT_APPLICATION);
        itsAidSsp.setServiceSpecificPermissions(new byte[]{0x01, 0x10});
        itsAidSspList.addItsAidSsp(itsAidSsp);
        subjectAttributes.setAppPermissions(itsAidSspList);
        batcInnerEcRequest.setItsId(itsId);
        batcInnerEcRequest.setCertificateFormat(certificateFormat);
        batcInnerEcRequest.setPublicKeys(batcPublicKeys);
        batcInnerEcRequest.setRequestedSubjectAttributes(subjectAttributes);
        SecuredMessage securedMessage = SecureMessageUtils.buildSignSecuredMessage(null,
                new HashAlgorithm(HashAlgorithm.SGD_SM3),
                new ItsAidInt(623),
                privateKeyIndex,
                privateKeyPassword,
                batcInnerEcRequest.getEncode());
        BATCInnerEcRequestSignedForPop signedForPop = new BATCInnerEcRequestSignedForPop();
        signedForPop.setPayload(securedMessage.getPayload());
        signedForPop.setVersion(securedMessage.getVersion());
        batcitsDataContent.setEnrolmentRequest(signedForPop);
        return batcitsDataContent;
    }

    /**
     * 构建EC申请请求结构体(NIST)
     *
     * @param privateKeyIndex
     * @param privateKeyPassword
     * @param imei
     * @param hostName
     * @return
     * @throws Exception
     */
    public static BATCITSDataContent buildNistECApplyRequest(int privateKeyIndex, String privateKeyPassword,String imei, String hostName) throws Exception {
        byte[] imeiHash = GMSSLSHA256DigestUtils.digestByBC(imei.getBytes());
        BATCITSDataContent batcitsDataContent = new BATCITSDataContent();
        OctetString itsId = new OctetString();//构建itsId
        itsId.setString(imeiHash);
        BATCCertificateFormat certificateFormat = new BATCCertificateFormat((byte) 2);//构建certificateFormat
        BATCInnerEcRequest batcInnerEcRequest = new BATCInnerEcRequest();
        BATCPublicKeys batcPublicKeys = new BATCPublicKeys();
        //构建PublicVerifyKey
        PublicVerifyKey verifyKey = new PublicVerifyKey();
        PublicKey publicKey = GMSSLECKeyUtils.getSignPublicKeyByYunhsm(privateKeyIndex,GMSSLECKeyUtils.NISTp256);
        verifyKey.setEccPoint(EccPointBuilder.build(publicKey, EccPointTypeEnum.UNCOMPRESSED));
        verifyKey.setEccCurve(new EccCurve(EccCurve.NIST_P_256));
        batcPublicKeys.setVerifyKey(verifyKey);
        //构建publicEncryptionKey
        PublicEncryptionKey publicEncryptionKey = new PublicEncryptionKey();
        publicEncryptionKey.setSupportedSymmAlg(new SymmetricAlgorithm(SymmetricAlgorithm.AES_128_CCM));
        publicEncryptionKey.setEccCurve(new EccCurve(EccCurve.NIST_P_256));
        publicEncryptionKey.setPublicKey(EccPointBuilder.build(publicKey, EccPointTypeEnum.COMPRESSED_Y));
        batcPublicKeys.setEncryptionKey(publicEncryptionKey);
        BATCCertificateSubjectAttributes subjectAttributes = new BATCCertificateSubjectAttributes();
        BATCCertificateId batcCertificateId = new BATCCertificateId();
        BATCHostname batcHostname = new BATCHostname();
        batcHostname.setString(hostName.getBytes());
        batcCertificateId.setName(batcHostname);
        subjectAttributes.setId(batcCertificateId);
        ValidityPeriod validityPeriod = new ValidityPeriod();
        TimeStartAndEnd timeStartAndEnd = new TimeStartAndEnd();
        timeStartAndEnd.setStartValidity(new Time32(TimeUtils.getNowTime()));
        timeStartAndEnd.setEndValidity(new Time32(TimeUtils.getTimeAfterYear(1)));
        validityPeriod.setTimeStartAndEnd(timeStartAndEnd);
        subjectAttributes.setValidityPeriod(validityPeriod);
        GeographicRegion geographicRegion = new GeographicRegion();
        SequenceOfRectangularRegion regions = new SequenceOfRectangularRegion();
        RectangularRegion region = new RectangularRegion();
        TwoDLocation twoDLocation = new TwoDLocation();
        twoDLocation.setLongitude(new Longitude(123));
        twoDLocation.setLatitude(new Latitude(465));
        region.setNorthWest(twoDLocation);
        region.setSouthEast(twoDLocation);
        regions.addRectangularRegion(region);
        regions.addRectangularRegion(region);
        regions.addRectangularRegion(region);
        regions.addRectangularRegion(region);
        regions.addRectangularRegion(region);
        geographicRegion.setRectangularRegion(regions);
        subjectAttributes.setRegion(geographicRegion);
        SequenceOfItsAidSspList itsAidSspList = new SequenceOfItsAidSspList();
        ItsAidSsp itsAidSsp = new ItsAidSsp();
        itsAidSsp.setItsAid(ItsAid.TRAFFIC_LIGHT_APPLICATION);
        itsAidSsp.setServiceSpecificPermissions(new byte[]{0x01, 0x10});
        itsAidSspList.addItsAidSsp(itsAidSsp);
        subjectAttributes.setAppPermissions(itsAidSspList);
        batcInnerEcRequest.setItsId(itsId);
        batcInnerEcRequest.setCertificateFormat(certificateFormat);
        batcInnerEcRequest.setPublicKeys(batcPublicKeys);
        batcInnerEcRequest.setRequestedSubjectAttributes(subjectAttributes);
        SecuredMessage securedMessage = SecuredMessageBuilder.buildSelfSignedDataSecuredMessage(new ItsAidInt(623),
                new SdfPrivateKey(privateKeyIndex,privateKeyPassword.getBytes()),
                batcInnerEcRequest.getEncode(),
                EccCurveTypeEnum.NIST_P_256);
        BATCInnerEcRequestSignedForPop signedForPop = new BATCInnerEcRequestSignedForPop();
        signedForPop.setPayload(securedMessage.getPayload());
        signedForPop.setVersion(securedMessage.getVersion());
        batcitsDataContent.setEnrolmentRequest(signedForPop);
        return batcitsDataContent;
    }

    /**
     * 构建EC申请响应结构体
     *
     * @param requestHashBytes 请求HASH
     * @param value            响应枚举成员
     * @param ecaPrivateKey    eca证书私钥
     * @param ecaCert          eca证书
     * @param ecCert           ec证书
     * @return
     * @throws Exception
     */
    public static BATCEnrollmentCertResponseData buildECApplyReponse(byte[] requestHashBytes, BATCEnrolmentResponseCode.Value value, PrivateKey ecaPrivateKey, Certificate ecaCert, Certificate ecCert) throws Exception {
        BATCEnrollmentCertResponseData enrollmentCertResponseData = new BATCEnrollmentCertResponseData();
        BATCITSDataContent batcitsDataContent = new BATCITSDataContent();
        BATCInnerEcResponse batcInnerEcResponse = new BATCInnerEcResponse();
        BATCEnrolmentResponseCode batcEnrolmentResponseCode = new BATCEnrolmentResponseCode(value);
        OctetString octetString = new OctetString();
        octetString.setLength(16);
        octetString.setString(requestHashBytes);
        batcInnerEcResponse.setRequestHash(octetString);
        batcInnerEcResponse.setResponseCode(batcEnrolmentResponseCode);
        if (ecCert != null) {
            batcInnerEcResponse.setEcCert(ecCert);
        }
        batcitsDataContent.setEnrolmentResponse(batcInnerEcResponse);
        SecuredMessage securedMessage = SecuredMessageBuilder.buildSignedDataSecuredMessage(new ItsAidInt(623), ecaPrivateKey, ecaCert, batcitsDataContent.getEncode());
        enrollmentCertResponseData.setPayload(securedMessage.getPayload());
        enrollmentCertResponseData.setVersion(securedMessage.getVersion());
        return enrollmentCertResponseData;
    }
}
