package com.xdja.pki.oer.batc.builder;

import com.xdja.pki.oer.batc.BATCEasVassServerTimeResponse;
import com.xdja.pki.oer.batc.BATCITSDataContent;
import com.xdja.pki.oer.core.TimeUtils;
import com.xdja.pki.oer.gbt.asn1.Certificate;
import com.xdja.pki.oer.gbt.asn1.ItsAidInt;
import com.xdja.pki.oer.gbt.asn1.SecuredMessage;
import com.xdja.pki.oer.gbt.asn1.Time32;
import com.xdja.pki.oer.gbt.asn1.data.SecuredMessageBuilder;

import java.security.PrivateKey;
import java.util.Date;

public class BATCECServerTimeBuilder {

    /**
     * 构建时间同步响应结构体
     *
     * @param ecaPrivateKey
     * @param ecaCert
     * @param date
     * @return
     * @throws Exception
     */
    public static BATCEasVassServerTimeResponse buildECServerTimeReponse(PrivateKey ecaPrivateKey, Certificate ecaCert, Date date) throws Exception {
        BATCEasVassServerTimeResponse certResponseData = new BATCEasVassServerTimeResponse();
        BATCITSDataContent itsDataContent = new BATCITSDataContent();
        itsDataContent.setServerTime(new Time32(TimeUtils.getTimeFromDate(date)));
        SecuredMessage securedMessage = SecuredMessageBuilder.buildSignedDataSecuredMessage(new ItsAidInt(36), ecaPrivateKey, ecaCert, itsDataContent.getEncode());
        certResponseData.setPayload(securedMessage.getPayload());
        certResponseData.setVersion(securedMessage.getVersion());
        return certResponseData;
    }
}
