package com.xdja.pki.oer.batc.builder;

import com.xdja.pki.oer.batc.BATCEnrollmentCertRequestDataSign;
import com.xdja.pki.oer.batc.BATCITSDataContent;
import com.xdja.pki.oer.gbt.asn1.Certificate;
import com.xdja.pki.oer.gbt.asn1.ItsAidInt;
import com.xdja.pki.oer.gbt.asn1.SecuredMessage;
import com.xdja.pki.oer.gbt.asn1.data.SecuredMessageBuilder;

import java.security.PrivateKey;

public class BATCECUpdateBuilder {
    /**
     * 构建EC更新申请结构体
     *
     * @param privateKey
     * @param ecCert
     * @param batcitsDataContent
     * @return
     * @throws Exception
     */
    public static BATCEnrollmentCertRequestDataSign buildECUpdateRequest(PrivateKey privateKey, Certificate ecCert, BATCITSDataContent batcitsDataContent) throws Exception {
        BATCEnrollmentCertRequestDataSign certRequestDataSign = new BATCEnrollmentCertRequestDataSign();
        SecuredMessage securedMessage = SecuredMessageBuilder.buildSignedDataSecuredMessage(new ItsAidInt(623), privateKey, ecCert, batcitsDataContent.getEncode());
        certRequestDataSign.setPayload(securedMessage.getPayload());
        certRequestDataSign.setVersion(securedMessage.getVersion());
        return certRequestDataSign;
    }
}
