package com.xdja.pki.oer.batc.gccf;

import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.base.Uint16;
import com.xdja.pki.oer.batc.lccf.CertificateStore;
import org.bouncycastle.util.BigIntegers;

import java.util.Vector;

/**
 * GCCF结构体定义
 * GlobalCertificateChainFile ::= SEQUENCE {
 * version Uint16,
 * requiredCertStore CertificateStore --RCA、PG、CRLG、ICA、ECA、PCA
 * }
 *
 * @author wzs
 * @version v1.0
 * @ClassName GlobalCertificateChainFile
 * @Date 2019/12/24 11:19
 */
public class GlobalCertificateChainFile extends Sequence {
    private Uint16 version;
    private CertificateStore requiredCerStore;

    public GlobalCertificateChainFile(boolean isExtension, boolean hasOptional) {
        super(isExtension, hasOptional);
    }

    public GlobalCertificateChainFile() {
        super(false, false);
    }

    public Uint16 getVersion() {
        return version;
    }

    public void setVersion(Uint16 version) {
        this.version = version;
    }

    public CertificateStore getRequiredCerStore() {
        return requiredCerStore;
    }

    public void setRequiredCerStore(CertificateStore requiredCerStore) {
        this.requiredCerStore = requiredCerStore;
    }

    public static GlobalCertificateChainFile getInstance(byte[] data) throws Exception {
        GlobalCertificateChainFile globalCertificateChainFile = new GlobalCertificateChainFile();
        byte[] versionBytes = new byte[2];
        System.arraycopy(data, 0, versionBytes, 0, versionBytes.length);
        globalCertificateChainFile.setVersion(new Uint16(BigIntegers.fromUnsignedByteArray(versionBytes).intValue()));
        CertificateStore certificateStore = CertificateStore.getInstance(getGoal(data, 2));
        globalCertificateChainFile.setRequiredCerStore(certificateStore);
        globalCertificateChainFile.setGoal(certificateStore.getGoal());
        return globalCertificateChainFile;
    }

    /**
     * 获得goal
     *
     * @param data    总字节数
     * @param byteNum 已解析字节数
     * @return
     */
    public static byte[] getGoal(byte[] data, int byteNum) {
        byte[] goal = new byte[data.length - byteNum];
        System.arraycopy(data, byteNum, goal, 0, goal.length);
        return goal;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(version);
        vector.add(requiredCerStore);
        return vector;
    }
}
