package com.xdja.pki.oer.batc.gccf;

import com.xdja.pki.oer.base.Uint16;
import com.xdja.pki.oer.batc.lccf.CertificateStore;
import com.xdja.pki.oer.gbt.asn1.SequenceOfCertificate;

/**
 * GCCF文件构建类
 *
 * @author wzs
 * @version v1.0
 * @ClassName GlobalCertificateChainFileBuilder
 * @Date 2019/12/24 11:19
 */
public class GlobalCertificateChainFileBuilder {
    /**
     * 构建GCCF
     *
     * @param gccfVersion
     * @param certs
     * @return
     * @throws Exception
     */
    public static GlobalCertificateChainFile build(int gccfVersion, SequenceOfCertificate certs) throws Exception {
        Uint16 gccfVersionUint16 = new Uint16(gccfVersion);
        CertificateStore certificateStore = new CertificateStore();
        certificateStore.setCerts(certs);
        GlobalCertificateChainFile gccf = new GlobalCertificateChainFile();
        gccf.setVersion(gccfVersionUint16);
        gccf.setRequiredCerStore(certificateStore);
        return gccf;
    }
}
