package com.xdja.pki.oer.batc.gpf;

import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.gbt.asn1.SecuredMessage;

import java.util.Vector;

/**
 * GPF文件结构体定义
 * GlobalPolicyFile ::= SEQUENCE {
 * globalParameters SecuredMessage
 * }
 *
 * @author wzs
 * @version v1.0
 * @ClassName GlobalPolicyFile
 * @Date 2020/01/02 11:19
 */
public class GlobalPolicyFile extends Sequence {
    private SecuredMessage globalParameters;

    public GlobalPolicyFile(boolean isExtension, boolean hasOptional) {
        super(isExtension, hasOptional);
    }

    public GlobalPolicyFile() {
        super(false, false);
    }

    public SecuredMessage getGlobalParameters() {
        return globalParameters;
    }

    public void setGlobalParameters(SecuredMessage globalParameters) {
        this.globalParameters = globalParameters;
    }


    public static GlobalPolicyFile getInstance(byte[] data) throws Exception {
        GlobalPolicyFile globalPolicyFile = new GlobalPolicyFile();
        SecuredMessage globalParameters = SecuredMessage.getInstance(data);
        globalPolicyFile.setGlobalParameters(globalParameters);
        globalPolicyFile.setGoal(globalParameters.getGoal());
        return globalPolicyFile;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(globalParameters);
        return vector;
    }
}
