package com.xdja.pki.oer.batc.lccf;

import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.gbt.asn1.SequenceOfCertificate;

import java.util.Vector;

/**
 * 证书库结构体定义
 * CertificateStore ::= SEQUENCE {
 * certs SEQUENCE SIZE(0..MAX) OF Certificate,--国标证书格式
 * }
 *
 * @author wzs
 * @version v1.0
 * @ClassName CertificateStore
 * @Date 2019/12/24 11:19
 */
public class CertificateStore extends Sequence {
    private SequenceOfCertificate certs;

    public CertificateStore(boolean isExtension, boolean hasOptional) {
        super(isExtension, hasOptional);
    }

    public CertificateStore() {
        super(false, false);
    }

    public static CertificateStore getInstance(byte[] data) throws Exception {
        CertificateStore certificateStore = new CertificateStore();
        SequenceOfCertificate sequenceOfCertificate = SequenceOfCertificate.getInstance(data);
        certificateStore.setCerts(sequenceOfCertificate);
        certificateStore.setGoal(sequenceOfCertificate.getGoal());
        return certificateStore;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(certs);
        return vector;
    }

    public SequenceOfCertificate getCerts() {
        return certs;
    }

    public void setCerts(SequenceOfCertificate certs) {
        this.certs = certs;
    }
}
