package com.xdja.pki.oer.batc.lccf;

import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.base.Uint16;
import org.bouncycastle.util.BigIntegers;

import java.util.Vector;

/**
 * 版本结构体定义
 * CompositeVersion ::= SEQUENCE {
 * gccfVersion Uint16,
 * lccfVersion Uint16
 * }
 *
 * @author wzs
 * @version v1.0
 * @ClassName CompositeVersion
 * @Date 2019/12/24 11:19
 */
public class CompositeVersion extends Sequence {
    private Uint16 gccfVersion;
    private Uint16 lccfVersion;

    public CompositeVersion(boolean isExtension, boolean hasOptional) {
        super(isExtension, hasOptional);
    }

    public CompositeVersion() {
        super(false, false);
    }

    public Uint16 getGccfVersion() {
        return gccfVersion;
    }

    public void setGccfVersion(Uint16 gccfVersion) {
        this.gccfVersion = gccfVersion;
    }

    public Uint16 getLccfVersion() {
        return lccfVersion;
    }

    public void setLccfVersion(Uint16 lccfVersion) {
        this.lccfVersion = lccfVersion;
    }

    public static CompositeVersion getInstance(byte[] data) throws Exception {
        CompositeVersion compositeVersion = new CompositeVersion();

        byte[] gccfVersionBytes = new byte[2];
        System.arraycopy(data, 0, gccfVersionBytes, 0, gccfVersionBytes.length);
        compositeVersion.setGccfVersion(new Uint16(BigIntegers.fromUnsignedByteArray(gccfVersionBytes).intValue()));

        byte[] lccfVersionBytes = new byte[2];
        System.arraycopy(data, 2, lccfVersionBytes, 0, lccfVersionBytes.length);
        compositeVersion.setLccfVersion(new Uint16(BigIntegers.fromUnsignedByteArray(lccfVersionBytes).intValue()));

        byte[] goal = new byte[data.length - 4];
        System.arraycopy(data, 4, goal, 0, goal.length);

        compositeVersion.setGoal(goal);
        return compositeVersion;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(gccfVersion);
        vector.add(lccfVersion);
        return vector;
    }
}
