package com.xdja.pki.oer.batc.lccf;

import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.base.Uint16;
import org.bouncycastle.util.BigIntegers;

import java.util.Vector;

/**
 * LCCF响应结构体定义
 * LccfFile ::= SEQUENCE {
 * code Uint16,--错误码。200：返回新文件，304：无文件返回，-1：异常
 * fileContent LocalCertificateChainFile
 * }
 *
 * @author wzs
 * @version v1.0
 * @ClassName LCCFDownLoad
 * @Date 2019/12/24 11:19
 */
public class LCCFDownLoad extends Sequence {
    private Uint16 code;
    private LocalCertificateChainFile fileContent;

    public LCCFDownLoad(boolean isExtension, boolean hasOptional) {
        super(isExtension, hasOptional);
    }

    public LCCFDownLoad() {
        super(false, false);
    }

    public static LCCFDownLoad getInstance(byte[] data) throws Exception {
        LCCFDownLoad lccfDownLoad = new LCCFDownLoad();
        byte[] codeBytes = new byte[2];
        System.arraycopy(data, 0, codeBytes, 0, codeBytes.length);
        lccfDownLoad.setCode(new Uint16(BigIntegers.fromUnsignedByteArray(codeBytes).intValue()));
        byte[] goal = new byte[data.length - codeBytes.length];
        if (goal.length > 0) {
            System.arraycopy(data, 2, goal, 0, goal.length);
            LocalCertificateChainFile localCertificateChainFile = LocalCertificateChainFile.getInstance(goal);
            lccfDownLoad.setFileContent(localCertificateChainFile);
            lccfDownLoad.setGoal(localCertificateChainFile.getGoal());
        }
        return lccfDownLoad;
    }

    public Uint16 getCode() {
        return code;
    }

    public void setCode(Uint16 code) {
        this.code = code;
    }

    public LocalCertificateChainFile getFileContent() {
        return fileContent;
    }

    public void setFileContent(LocalCertificateChainFile fileContent) {
        this.fileContent = fileContent;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(code);
        vector.add(fileContent);
        return vector;
    }
}
